package yangtz.cs.liu.dingding.vo;

import lombok.Data;

import java.util.List;

@Data
public class DingJiaXiaoVo {

    /**
     * 年纪id
     */
    Integer gradeId;

    /**
     * 年纪名称
     */
    String gradeName;

    /**
     * 班级信息
     */
    List<ClassInfo> classInfoList;

    /**
     * 班级信息
     */
 @Data
 public class  ClassInfo{

        /**
         * 班级id
         */
        Integer classId;

        /**
         * 年纪名称
         */
        String className;

        /**
         * 学生信息
         */
        List<StudentUserInfo> studentUserInfos;
        /**
         * 老师信息
         */
        List<StudentUserInfo> teacherUserInfos;
        /**
         * 监护人信息
         */
        List<StudentUserInfo> guardianUserInfos;
    }

    /**
     * 学生信息
     */
    @Data
    public class StudentUserInfo{

    /**
     * 班级id
     */
    Integer classId;

    /**
     * 人员的userId。
     */
    String userId;

    /**
     * 人员姓名。
     */
    String name;
    /**
     * 人员的unionId，无手机号的学生为""。
     */
    String unionid;

    /**
     * 家校人员角色。
     * teacher：老师
     * guardian：监护人
     * student：学生
     */
    String role;

    /**
     * 只在老师角色下意义。
     * 1：班主任
     * 0：非班主任
     */
    String isAdviser;

    /**
     * 学号，只有在学生角色下才有意义，并且需确认各个班级的设置，如果没有设置，则不会返回此字段。
     */
    String studentNo;

        /**
         * 手机号
         */
    String mobile;



    }




}
