package yangtz.cs.liu.dingding.service.impl.dingDept;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dingtalk.api.response.OapiV2DepartmentGetResponse;
import com.dingtalk.api.response.OapiV2DepartmentListsubResponse;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.student.SchoolStudentClasses;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.dingding.domain.dingDept.SysDdDept;
import yangtz.cs.liu.dingding.mapper.dingDept.DdDeptMapper;
import yangtz.cs.liu.dingding.service.dingDept.IDdDeptService;
import yangtz.cs.liu.dingding.utils.AccessTokenUtils;
import yangtz.cs.liu.dingding.utils.DingDeptUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class DdDeptServcieImpl implements IDdDeptService {

    @Autowired
    private DingDeptUtils dingDeptUtils;
    @Autowired
    private DdDeptMapper ddDeptMapper;
    @Autowired
    private AccessTokenUtils accessTokenUtils;
    //年级表
    @Autowired
    ISchoolGradeService schoolGradeService;

    //学校班级
    @Autowired
    ISchoolClassService iSchoolClassService;
    /**
     * 获取钉钉全部部门列表
     * @return
     */
    @Override
    public List<OapiV2DepartmentListsubResponse.DeptBaseResponse> getDeptList() {
        Long deptId = 1L;
        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptListAll = new ArrayList<>();
        //一级
        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList = dingDeptUtils.getDeptList(deptId, "");
        for (OapiV2DepartmentListsubResponse.DeptBaseResponse response : deptList) {
            if (response.getDeptId() != -7){
                deptListAll.add(response);
                //二级
                List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList1 = dingDeptUtils.getDeptList(response.getDeptId(), "");
                if (deptList1.size() > 0) {
                    for (OapiV2DepartmentListsubResponse.DeptBaseResponse response1 : deptList1) {
                        deptListAll.add(response1);
                        //三级
                        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList2 = dingDeptUtils.getDeptList(response1.getDeptId(), "");
                        if (deptList2.size() > 0){
                            for (OapiV2DepartmentListsubResponse.DeptBaseResponse response2 : deptList2) {
                                deptListAll.add(response2);
                                //四级
                                List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList3 = dingDeptUtils.getDeptList(response2.getDeptId(), "");
                                if (deptList3.size() > 0){
                                    deptListAll.addAll(deptList3);
                                    for (OapiV2DepartmentListsubResponse.DeptBaseResponse response3 : deptList3) {
                                        //五级
                                        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList4 = dingDeptUtils.getDeptList(response3.getDeptId(), "");
                                        if (deptList4.size() > 0){
                                            deptListAll.addAll(deptList4);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return deptListAll;
    }

    /**
     * 下拉钉钉部门列表到系统
     * @return
     */
    @Override
    @Transactional
    public int addDdDept() {
        Long deptId = 1L;
        //获取部门详情
        OapiV2DepartmentGetResponse.DeptGetResponse dept = dingDeptUtils.getDept(deptId, "");
        //新增顶级目录
        SysDdDept sysDdDept = new SysDdDept();
        sysDdDept.setDeptId(100L);
        sysDdDept.setParentId(0L);
        sysDdDept.setAncestors("0");
        sysDdDept.setDeptName(dept.getName());
        sysDdDept.setOrderNum(0L);
        sysDdDept.setDdDeptId(dept.getDeptId());
        sysDdDept.setDdParentId(0L);
        sysDdDept.setCreateBy("钉钉管理员");
        ddDeptMapper.insertDdDept(sysDdDept);

        //全部部门列表
        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptListAll = new ArrayList<>();

        //一级
        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList = dingDeptUtils.getDeptList(deptId, "");
        for (OapiV2DepartmentListsubResponse.DeptBaseResponse response : deptList) {
            if (response.getDeptId() != -7){
                //获取部门详情
                OapiV2DepartmentGetResponse.DeptGetResponse dept1 = dingDeptUtils.getDept(response.getDeptId(), "");
                //新增一级目录
                SysDdDept sysDdDept1 = new SysDdDept();
                sysDdDept1.setParentId(sysDdDept.getDeptId());
                sysDdDept1.setAncestors("0," + sysDdDept.getDeptId());
                sysDdDept1.setDeptName(response.getName());
                sysDdDept1.setOrderNum(dept1.getOrder());
                sysDdDept1.setDdDeptId(response.getDeptId());
                sysDdDept1.setDdParentId(response.getParentId());
                sysDdDept1.setCreateBy("钉钉管理员");
                ddDeptMapper.insertDdDept(sysDdDept1);

                deptListAll.add(response);
                //二级
                List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList1 = dingDeptUtils.getDeptList(response.getDeptId(), "");
                if (deptList1.size() > 0) {
                    for (OapiV2DepartmentListsubResponse.DeptBaseResponse response1 : deptList1) {
                        //获取部门详情
                        OapiV2DepartmentGetResponse.DeptGetResponse dept2 = dingDeptUtils.getDept(response1.getDeptId(), "");
                        //新增二级目录
                        SysDdDept sysDdDept2 = new SysDdDept();
                        sysDdDept2.setParentId(sysDdDept1.getDeptId());
                        sysDdDept2.setAncestors(sysDdDept1.getAncestors() + "," + sysDdDept1.getDeptId());
                        sysDdDept2.setDeptName(response1.getName());
                        sysDdDept2.setOrderNum(dept2.getOrder());
                        sysDdDept2.setDdDeptId(response1.getDeptId());
                        sysDdDept2.setDdParentId(response1.getParentId());
                        sysDdDept2.setCreateBy("钉钉管理员");
                        ddDeptMapper.insertDdDept(sysDdDept2);

                        deptListAll.add(response1);
                        //三级
                        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList2 = dingDeptUtils.getDeptList(response1.getDeptId(), "");
                        if (deptList2.size() > 0){
                            for (OapiV2DepartmentListsubResponse.DeptBaseResponse response2 : deptList2) {
                                //获取部门详情
                                OapiV2DepartmentGetResponse.DeptGetResponse dept3 = dingDeptUtils.getDept(response2.getDeptId(), "");
                                //新增三级目录
                                SysDdDept sysDdDept3 = new SysDdDept();
                                sysDdDept3.setParentId(sysDdDept2.getDeptId());
                                sysDdDept3.setAncestors(sysDdDept2.getAncestors() + "," + sysDdDept2.getDeptId());
                                sysDdDept3.setDeptName(response2.getName());
                                sysDdDept3.setOrderNum(dept3.getOrder());
                                sysDdDept3.setDdDeptId(response2.getDeptId());
                                sysDdDept3.setDdParentId(response2.getParentId());
                                sysDdDept3.setCreateBy("钉钉管理员");
                                ddDeptMapper.insertDdDept(sysDdDept3);

                                deptListAll.add(response2);
                                //四级
                                List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList3 = dingDeptUtils.getDeptList(response2.getDeptId(), "");
                                if (deptList3.size() > 0){
                                    deptListAll.addAll(deptList3);
                                    for (OapiV2DepartmentListsubResponse.DeptBaseResponse response3 : deptList3) {
                                        //获取部门详情
                                        OapiV2DepartmentGetResponse.DeptGetResponse dept4 = dingDeptUtils.getDept(response3.getDeptId(), "");
                                        //新增四级目录
                                        SysDdDept sysDdDept4 = new SysDdDept();
                                        sysDdDept4.setParentId(sysDdDept3.getDeptId());
                                        sysDdDept4.setAncestors(sysDdDept3.getAncestors() + "," + sysDdDept3.getDeptId());
                                        sysDdDept4.setDeptName(response3.getName());
                                        sysDdDept4.setOrderNum(dept4.getOrder());
                                        sysDdDept4.setDdDeptId(response3.getDeptId());
                                        sysDdDept4.setDdParentId(response3.getParentId());
                                        sysDdDept4.setCreateBy("钉钉管理员");
                                        ddDeptMapper.insertDdDept(sysDdDept4);

                                        //五级
                                        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList4 = dingDeptUtils.getDeptList(response3.getDeptId(), "");
                                        if (deptList4.size() > 0){
                                            deptListAll.addAll(deptList4);
                                            for (OapiV2DepartmentListsubResponse.DeptBaseResponse response4 : deptList4) {
                                                //获取部门详情
                                                OapiV2DepartmentGetResponse.DeptGetResponse dept5 = dingDeptUtils.getDept(response4.getDeptId(), "");
                                                //新增五级目录
                                                SysDdDept sysDdDept5 = new SysDdDept();
                                                sysDdDept5.setParentId(sysDdDept4.getDeptId());
                                                sysDdDept5.setAncestors(sysDdDept4.getAncestors() + "," + sysDdDept4.getDeptId());
                                                sysDdDept5.setDeptName(response4.getName());
                                                sysDdDept5.setOrderNum(dept5.getOrder());
                                                sysDdDept5.setDdDeptId(response4.getDeptId());
                                                sysDdDept5.setDdParentId(response4.getParentId());
                                                sysDdDept5.setCreateBy("钉钉管理员");
                                                ddDeptMapper.insertDdDept(sysDdDept5);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return 1;
    }

    /**
     * 同步钉钉部门列表
     * @return
     */
    @Override
    @Transactional
    public String syncDdDept() {
        //获取系统所有部门列表
        List<SysDdDept> deptList = ddDeptMapper.selectDdDeptList(new SysDdDept());
        if (deptList.size() <= 0){
            addDdDept();
        }else{
            //获取钉钉所有部门列表
            List<OapiV2DepartmentListsubResponse.DeptBaseResponse> ddDeptList = getDeptList();
            //存放钉钉部门不存在系统库集合
            List<OapiV2DepartmentListsubResponse.DeptBaseResponse> ddDeptList1 = new ArrayList<>();
            ddDeptList1.addAll(ddDeptList);


            //存放钉钉删除了的部门集合
            List<SysDdDept> deptList1 = new ArrayList<>();
            deptList1.addAll(deptList);

            //判断钉钉部门列表是否都在系统部门列表中
            for (OapiV2DepartmentListsubResponse.DeptBaseResponse ddDept : ddDeptList) {
                for (SysDdDept dept : deptList) {
                    if (ddDept.getDeptId().equals(dept.getDdDeptId())){
                        //存在，从集合中去除
                        ddDeptList1.remove(ddDept);
                    }
                }
            }

            //新增不存在系统库的部门
            if(ddDeptList1.size() > 0){
                for (OapiV2DepartmentListsubResponse.DeptBaseResponse ddDept : ddDeptList1) {
                    //钉钉父部门id
                    Long ddParentId = ddDept.getParentId();
                    //查询父部门信息
                    SysDdDept ddDept1 = ddDeptMapper.selectDeptByDdDeptId(ddParentId);
                    //新增
                    SysDdDept sysDdDept = new SysDdDept();
                    sysDdDept.setParentId(ddDept1.getDeptId());
                    sysDdDept.setAncestors(ddDept1.getAncestors() + ddDept1.getDeptId());
                    sysDdDept.setDeptName(ddDept.getName());
                    sysDdDept.setOrderNum(ddDept.getDeptId());
                    sysDdDept.setDdDeptId(ddDept.getDeptId());
                    sysDdDept.setDdParentId(ddParentId);
                    sysDdDept.setCreateBy("钉钉管理员");
                    ddDeptMapper.insertDdDept(sysDdDept);
                }
            }

            //判断钉钉中删除的部门是否还存在系统部门中
            for (SysDdDept dept : deptList) {
                for (OapiV2DepartmentListsubResponse.DeptBaseResponse ddDept : ddDeptList) {
                    if (ddDept.getDeptId().equals(dept.getDdDeptId())){
                        deptList1.remove(dept);
                    }
                }
            }
            //删除系统部门中存在的钉钉已删除的部门
            if (deptList1.size() > 0){
                for (SysDdDept dept : deptList1) {
                    if (dept.getDeptId() != 100){
                        ddDeptMapper.deleteDdDeptById(dept.getDeptId());
                    }
                }
            }

            //更新系统部门信息
            //获取部门详情
            OapiV2DepartmentGetResponse.DeptGetResponse djDept = dingDeptUtils.getDept(1L, "");
            //修改顶级目录
            SysDdDept dept = new SysDdDept();
            dept.setDdDeptId(djDept.getDeptId());
            dept.setDeptName(djDept.getName());
            dept.setUpdateBy("钉钉管理员");
            ddDeptMapper.updateDdDeptByDdDeptId(dept);
            for (OapiV2DepartmentListsubResponse.DeptBaseResponse ddDept : ddDeptList) {
                for (SysDdDept sysDdDept : deptList) {
                    if (ddDept.getDeptId().equals(sysDdDept.getDdDeptId())){
                        //判断父部门是否发生改变
                        if (!(ddDept.getParentId().equals(sysDdDept.getDdParentId()))){
                            //钉钉父部门id
                            Long ddParentId = ddDept.getParentId();
                            //查询父部门信息
                            SysDdDept ddParentDept = ddDeptMapper.selectDeptByDdDeptId(ddParentId);
                            sysDdDept.setParentId(ddParentDept.getDeptId());
                            sysDdDept.setAncestors(ddParentDept.getAncestors() + "," + ddParentDept.getDeptId());
                            sysDdDept.setDdParentId(ddDept.getParentId());
                            sysDdDept.setUpdateBy("钉钉管理员");
                            ddDeptMapper.updateDdDeptByDdDeptId(sysDdDept);
                        }
                        //判断部门基本信息是否发生改变
                        if(!(ddDept.getName().equals(sysDdDept.getDeptName()))){
                            sysDdDept.setDeptName(ddDept.getName());
                            sysDdDept.setUpdateBy("钉钉管理员");
                            ddDeptMapper.updateDdDeptByDdDeptId(sysDdDept);
                        }
                    }
                }
            }
        }
        return "同步成功";
    }

    /**
     * 钉钉部门创建
     * @param eventJson
     * @return
     */
    @Override
    @Transactional
    public int ddDeptCreate(JSONObject eventJson) {
        int i= 0;
        String ddDeptId = eventJson.getString("DeptId");
        String replace = ddDeptId.replace("[", "");
        String deptIds = replace.replace("]", "");
        String[] split = deptIds.split(",");
        for (String deptId : split) {
            //获取部门详情
            OapiV2DepartmentGetResponse.DeptGetResponse dept = dingDeptUtils.getDept(Long.valueOf(deptId), "");
            //判断是否家校通讯录过来的请求
            if (StringUtils.isNotEmpty(dept.getTags())){
                if (dept.getTags().equals("campus") || dept.getTags().equals("period") || dept.getTags().equals("period") || dept.getTags().equals("class") ){
                    return 1;
                }
            }
            //获取父部门信息
            Long ddParentId = dept.getParentId();
            SysDdDept sysDdDept = ddDeptMapper.selectDeptByDdDeptId(ddParentId);
            //新增部门
            SysDdDept ddDept = new SysDdDept();
            ddDept.setParentId(sysDdDept.getDeptId());
            ddDept.setAncestors(sysDdDept.getAncestors() + "," + sysDdDept.getDeptId());
            ddDept.setDeptName(dept.getName());
            ddDept.setOrderNum(dept.getOrder());
            ddDept.setDdDeptId(dept.getDeptId());
            ddDept.setDdParentId(dept.getParentId());
            ddDept.setCreateBy("钉钉管理员");
            i += ddDeptMapper.insertDdDept(ddDept);
        }
        return i;
    }

    /**
     * 钉钉部门修改
     * @param eventJson
     * @return
     */
    @Override
    public int ddDeptUpdate(JSONObject eventJson) {
        int i = 0;
        String ddDeptId = eventJson.getString("DeptId");
        String replace = ddDeptId.replace("[", "");
        String deptIds = replace.replace("]", "");
        String[] split = deptIds.split(",");
        for (String deptId : split) {
            //获取部门详情
            OapiV2DepartmentGetResponse.DeptGetResponse dept = dingDeptUtils.getDept(Long.valueOf(deptId), "");
            //判断是否家校通讯录过来的请求
            if (StringUtils.isNotEmpty(dept.getTags())){
                if (dept.getTags().equals("campus") || dept.getTags().equals("period") || dept.getTags().equals("period") || dept.getTags().equals("class") ){
                    return 1;
                }
            }
            //获取父部门信息
            Long ddParentId = dept.getParentId();
            SysDdDept sysDdDept = ddDeptMapper.selectDeptByDdDeptId(ddParentId);
            //修改部门
            SysDdDept ddDept = new SysDdDept();
            ddDept.setParentId(sysDdDept.getDeptId());
            ddDept.setAncestors(sysDdDept.getAncestors() + "," + sysDdDept.getDeptId());
            ddDept.setDeptName(dept.getName());
            ddDept.setOrderNum(dept.getOrder());
            ddDept.setDdDeptId(dept.getDeptId());
            ddDept.setDdParentId(dept.getParentId());
            ddDept.setCreateBy("钉钉管理员");
            i += ddDeptMapper.updateDdDeptByDdDeptId(ddDept);
        }
        return i;
    }

    /**
     * 钉钉部门删除
     * @param eventJson
     * @return
     */
    @Override
    public int ddDeptDelete(JSONObject eventJson) {
        int i = 0;
        String ddDeptId = eventJson.getString("DeptId");
        String replace = ddDeptId.replace("[", "");
        String deptIds = replace.replace("]", "");
        String[] split = deptIds.split(",");
        for (String deptId : split) {
            //删除钉钉部门
            i += ddDeptMapper.deleteDdDeptByDdDeptId(Long.valueOf(deptId));
        }
        return i;
    }


    /**
     * 家乡通讯录部门新增
     */

    public Integer eduDeptInsert(JSONObject eventJson){
        String token = accessTokenUtils.getToken();

        Integer deptId = (Integer)eventJson.get("deptId");
        JSONObject jxDeptDate = this.getJxDeptDate(deptId, token);
        //部门别名
        String nick = (String)jxDeptDate.get("nick");
        //节点连，从顶层节点到当前节点的中间节点，其内容不包含当前节点。
        String chain = (String)jxDeptDate.get("chain");
        //部门ID。。
        Integer deptIdd = (Integer)jxDeptDate.get("dept_id");
        //部门类型节点类型。 campus：校区 period：学段 grade：年级  class：班级
        String deptType = (String)jxDeptDate.get("dept_type");
        //部 门 名称。
        String name = (String)jxDeptDate.get("name");
        //判断当前部 门 类型//只做 年级跟班级的判断
        if (deptType.equals("grade")){
            String gradeJi = name.substring(name.length() - 5);
            String grade = gradeJi.substring(0,gradeJi.length()-1);
            //年级直接新增
            SchoolGrade schoolGrade = new SchoolGrade();
            schoolGrade.setGradeValue(Integer.valueOf(this.gradeSubt(name)));
            schoolGrade.setGradeYear(grade);
            schoolGrade.setGradeName(gradeJi+"部");
            schoolGrade.setRemark(name);
            schoolGrade.setDdClassId(String.valueOf(deptId));
            schoolGrade.setCreateTime(new Date());
            schoolGrade.setCreateBy("admin");
            schoolGrade.setDelFlag("0");
            schoolGrade.setUpdateBy("admin");
            schoolGrade.setUpdateTime(new Date());
            schoolGradeService.save(schoolGrade);
        }else if(deptType.equals("class")){
            //找到级部
            String[] arra = new String[]{chain};
           String grDept = arra[arra.length-1];
            //级部id
            Long l = schoolGradeService.selectDdClassId(grDept);
            SchoolGrade byId = schoolGradeService.getById(l);
            //新增班级
            SchoolClass schoolClass = new SchoolClass();
            schoolClass.setSchoolYear(Integer.valueOf(byId.getSchoolYear()));
            schoolClass.setClassType("4");
            schoolClass.setGradeValue(byId.getGradeValue());
            schoolClass.setGradeName(byId.getGradeName());
            schoolClass.setClassValue(Integer.valueOf(jxDeptDate.getJSONObject("feature").get("class_level").toString()));
            schoolClass.setClassName(jxDeptDate.getJSONObject("feature").get("class_level").toString()+"班");
            schoolClass.setClassAlias(name);
            schoolClass.setCreateBy("admin");
            schoolClass.setCreateTime(new Date());
            schoolClass.setUpdateBy("admin");
            schoolClass.setUpdateTime(new Date());
            schoolClass.setGradeId(byId.getId());
            schoolClass.setDdClassId(deptIdd.toString());
            iSchoolClassService.save(schoolClass);
        }
        return 0;
    }


    /**
     * 删除部门 删除部门的时候人员必须清空才会去掉
     * @param eventJson
     * @return
     */
    public Integer eduDeptDelete(JSONObject eventJson){
        String token = accessTokenUtils.getToken();
        Integer deptId = (Integer)eventJson.get("deptId");
        JSONObject jxDeptDate = this.getJxDeptDate(deptId, token);
        //部门别名
        String nick = (String)jxDeptDate.get("nick");
        //节点连，从顶层节点到当前节点的中间节点，其内容不包含当前节点。
        String chain = (String)jxDeptDate.get("chain");
        //部门ID。。
        Integer deptIdd = (Integer)jxDeptDate.get("dept_id");
        //部门类型节点类型。 campus：校区 period：学段 grade：年级  class：班级
        String deptType = (String)jxDeptDate.get("dept_type");
        //部 门 名称。
        String name = (String)jxDeptDate.get("name");
        //判断当前部 门 类型//只做 年级跟班级的判断
        if (deptType.equals("grade")){
            //删除年级下边所有的班级
            Long l = schoolGradeService.selectDdClassId(deptIdd.toString());
            SchoolGrade byId = schoolGradeService.getById(l);
            //删除级部下的班级
            LambdaQueryWrapper<SchoolClass> icsclqw=new LambdaQueryWrapper<>();
            icsclqw.eq(SchoolClass::getGradeValue,byId.getGradeValue());
            icsclqw.eq(SchoolClass::getGradeName,byId.getGradeName());
            icsclqw.eq(SchoolClass::getSchoolYear,byId.getSchoolYear());
            List<SchoolClass> list = iSchoolClassService.list(icsclqw);
            //删除班级
            for (SchoolClass date :list){
                iSchoolClassService.removeById(date.getId());
            }
            //删除级部
            schoolGradeService.removeById(l);
        }else if(deptType.equals("class")){
                //删除部门
            Long l = iSchoolClassService.selectDdClassId(deptIdd.toString());
            iSchoolClassService.removeById(l);
        }
        return 0;
    }
    /**
     * 获取家校通讯录部门信息
     */

    public JSONObject getJxDeptDate(Integer deptId,String token){

        JSONObject bjParme = new JSONObject();
        bjParme.put("dept_id",deptId);
        String bjPost = HttpUtil.post("https://oapi.dingtalk.com/topapi/edu/dept/get?access_token="+token, bjParme);
        JSONObject bjObject = JSONObject.parseObject(bjPost);
        if ((Integer) bjObject.get("errcode") != 0){
            throw  new RuntimeException("获取部门失败:"+bjPost);
        }
        JSONObject jsonObject = bjObject.getJSONObject("result").getJSONObject("detail");
        return jsonObject;
    }
    private String gradeSubt(String grade){
        String gId = null;
        switch (grade){
            case  "一年级": return  gId = "1";
            case  "二年级": return  gId = "2";
            case  "三年级": return  gId = "3";
            case  "四年级": return  gId = "4";
            case  "五年级": return  gId = "5";
            case  "六年级": return gId = "6";
            case  "七年级": return gId = "7";
            case  "八年级": return gId = "8";
            case  "九年级": return gId = "9";
            case  "十年级": return gId = "10";
            case  "十一年级": return gId = "11";
            case  "十二年级": return gId = "12";
            case  "十三年级": return gId = "13";
            case  "十四年级": return gId = "14";
            case  "十五年级": return gId = "15";
            case  "十六年级": return gId = "16";
            case  "十七年级": return gId = "17";
            case  "十八年级": return gId = "18";
            case  "十九年级": return gId = "19";
            case  "二十年级": return gId = "20";
            case  "二十一年级": return gId = "21";
            case  "二十二级": return gId = "22";
            case  "二十三年级": return gId = "23";
            case  "二十四年级": return gId = "24";
            case  "二十五年级": return gId = "25";
            case  "二十六年级": return gId = "26";
            case  "二十七年级": return gId = "27";
            case  "二十八年级": return gId = "28";
            case  "二十九年级": return gId = "29";
            case  "三十年级": return gId = "30";

        }
        return gId;
    }

}
