package yangtz.cs.liu.dingding.mapper.dingUser;

import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.dingding.domain.dingGrade.SchoolGradeMentorCopy;
import yangtz.cs.liu.dingding.domain.dingUser.SysDdUser;
import yangtz.cs.liu.dingding.domain.dingUser.SysDdUserDept;

import java.util.List;

public interface DdUserMapper {

    /**
     * 批量新增钉钉用户
     */
    int batchInsertDdUser(@Param("list") List<SysDdUser> list);

    /**
     * 新增用户
     */
    int insertDdUser(SysDdUser sysDdUser);

    /**
     * 更新用户
     */
    int updateDdUser(SysDdUser sysDdUser);

    /**
     * 查询全部用户
     */
    List<SysDdUser> selectDdUserList(SysDdUser sysDdUser);

    /**
     * 新增用户部门关系
     */
    int insertDdUserDept(SysDdUserDept sysDdUserDept);

    /**
     * 删除用户
     */
    int deleteDdUser(Long userId);

    /**
     * 删除用户和部门关系
     */
    int deleteDdUserDept(Long userId);

    /**
     * 删除教师
     */
    int deleteDdTeacher(Long userId);

    /**
     * 根据用户id查询用户部门id列表
     */
    List<Long> selectDeptIdByUserId(Long userId);

    /**
     * 根据钉钉用户id查询用户信息
     * @param ddUserId
     * @return
     */
    SysDdUser selectDdUserByDdUserId(String ddUserId);

    /**
     * 新增级部成员
     * @param schoolGradeMentorCopy
     * @return
     */
    int insertGradeMentor(SchoolGradeMentorCopy schoolGradeMentorCopy);

    /**
     * 删除级部成员
     * @param userId
     * @return
     */
    int deleteGradeMentor(Long userId);
}
