package yangtz.cs.liu.dingding.controller.dingUser;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.dingding.service.impl.dingUser.DdUserServiceImpl;
import yangtz.cs.liu.dingding.utils.DingUserUtils;

/**
 * 钉钉用户管理
 */
@RestController
@RequestMapping("/dd/school/user")
public class DingUserController extends BaseController {

    @Autowired
    private DdUserServiceImpl ddUserService;

    /**
     * 获取钉钉所有用户id
     */
    @GetMapping("/getDdUserListAll")
    public TableDataInfo getDdUserListAll(){
        return getDataTable(ddUserService.getDdUserListAll());
    }

    /**
     * 下拉钉钉用户到系统
     */
    @PostMapping("/addDdUser")
    public AjaxResult addDdUser(){
        return toAjax(ddUserService.addDdUser());
    }

    /**
     * 用户表数据同步到教师表
     * @return
     */
    @PostMapping("/addDdTeacher")
    public AjaxResult addDdTeacher(){
        return toAjax(ddUserService.addDdTeacher());
    }

    /**
     * 同步钉钉用户列表
     */
    @GetMapping("/syncDdUser")
    public AjaxResult syncDdUser(){
        return AjaxResult.success(ddUserService.syncDdUser());
    }
}
