package yangtz.cs.liu.campus.vo.vehicle;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import java.util.Date;

@Data
public class VehicleApplicationVO  {
    private static final long serialVersionUID = 1L;

    @Excel(name = "id")
    private Long id;

    private String type;

    /**
     * 车辆id
     */
    private Long vehicleId;

    //车牌号
    @Excel(name = "车牌号")
    private String licensePlate;

    /**
     * 申请人id
     */
    //@Excel(name = "申请人id")
    private Long applicantId;

    /**
     * 用车人姓名
     */
    @Excel(name = "用车人姓名")
    private String applicantName;

    /**
     * 用车部门id
     */
    //@Excel(name = "用车部门id")
    private Long departmentId;

    /**
     * 用车部门名称
     */
    //@Excel(name = "用车部门名称")
    private String departName;

    /**
     * 用车原因
     */
    @Excel(name = "用车原因")
    private String reason;

    /**
     * 人数
     */
    @Excel(name = "人数")
    private Integer peopleNumber;

    /**
     * 出发地点
     */
    @Excel(name = "出发地点")
    private String departurePlace;

    /**
     * 目的地
     */
    @Excel(name = "目的地")
    private String destination;

    /**
     * 用车开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "用车开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 用车结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "用车结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 司机
     */
    @Excel(name = "司机")
    private String driver;

    /**
     * 用车类型（0公车，1私车公用）
     */
    @Excel(name = "用车类型", readConverterExp = "0=公车,1=私车公用")
    private String vehicleType;

    /**
     * 备注
     */
    @Excel(name = "备注")
    private String remarks;

    /**
     * 公里数
     */
    @Excel(name = "公里数")
    private String kilometers;

    /**
     * 状态（0未提交，1已提交）
     */
   // @Excel(name = "状态", readConverterExp = "0=通过,1驳回")
    private String state;

//    /**
//     * 流程实例ID
//     */
//    //@Excel(name = "流程实例ID")
//    private String instanceId;
//
//    /**
//     * 申请人
//     */
//    //@Excel(name = "申请人")
//    private String applyUser;

    /**
     * 提交时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    //@Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

//    private String roleKey;
//    private String roleName;

    //创建人
    private String createBy;
}
