package yangtz.cs.liu.campus.vo.time;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

/**
 * @author lyric
 * @date 2022/10/30 16:44
 */
@Data
public class SchoolTimeDetailVO {

    private static final long serialVersionUID = 1L;

    /** id */
    private Long id;

    /** shooltime主键 */
    private Long schoolTimeId;

    //@Excel(name = "课时")
    private String timeName;

    /** 序号 */
    //@Excel(name = "序号")
    private Integer sortId;

    /** 序号名称 */
    @Excel(name = "名称")
    private String sortName;

    /** 开始时间 */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "开始时间", width = 30, dateFormat = "HH:mm")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "结束时间", width = 30, dateFormat = "HH:mm")
    private Date endTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;
}
