package yangtz.cs.liu.campus.vo.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

@Data
public class SchoolTeacherDutyVO extends OurBaseEntity {

    private Long id;
    /**
     * 教师id
     */
    private Long teacherId;

    /**
     * 老师姓名
     */
    @Excel(name = "老师姓名")
    private String teacherName;

    /**
     * 值班类型
     */
    @Excel(name = "值班类型")
    private String dutyType;

    /**
     * 值班日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "值班日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date dutyTime;

    /**
     * 开始时间
     */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "开始时间", width = 30, dateFormat = "HH:mm")
    private Date dutyStartTime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "结束时间", width = 30, dateFormat = "HH:mm")
    private Date dutyEndTime;

    /**
     * 值班内容
     */
    @Excel(name = "值班内容")
    private String dutyContent;

    //联系电话
    private String teacherTel;

    //星期几
    private String weekDay;


}
