package yangtz.cs.liu.campus.vo.student;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

/**
 * 学生嘉奖对象 school_student_award
 *
 * @author ruoyi
 * @date 2024-01-08
 */
@Data
public class SchoolStudentAwardVo {

    /** 主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 学年 */
    @Excel(name = "学年",combo = {"2018-2019","2019-2020","2020-2021","2021-2022","2022-2023","2023-2024","2024-2025",
                                "2025-2026","2026-2027","2027-2028","2028-2029","2029-2030","2030-2031","2031-2032","2032-2033"})
    private String schoolYear;

    /** 学期 */
    @Excel(name = "学期",combo = {"第一学期","第二学期"})
    private String semester;

    /** 届别 */
    @Excel(name = "届别",combo = {"2018","2019","2020","2021","2022","2023","2024","2025","2026","2027","2028","2029","2030","2031","2032","2033"})
    private String year;

    /** 年级 */
    @Excel(name = "年级",combo = {"高一","高二","高三"})
    private String grade;

    /** 班级 */
    @Excel(name = "班级",combo = {"1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16",
                            "17","18","19","20","21","22","23","24","25","26","27","28","29","30","31","32","33","34","35","36","37","38","39","40"})
    private String className;

    /** 班级类型 */
    @Excel(name = "班级类型",combo = {"提高班","普通班","音乐班","美术班","体育班","特优班","春季班"})
    private String classType;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 性别 */
    @Excel(name = "性别",combo = {"男","女"})
    private String sex;

    /** 班主任id */
    private Long classTeacherId;

    /** 班主任 */
    @Excel(name = "班主任")
    private String classTeacher;

    /** 级部主任id */
    private Long departmentDirectorId;

    /** 级部主任 */
    @Excel(name = "级部主任")
    private String departmentDirector;

    /** 嘉奖类别 */
    @Excel(name = "嘉奖类别")
    private String awardType;

    /** 嘉奖级别 */
    @Excel(name = "嘉奖级别",combo = {"国家级","省级","市级","校级","级部"})
    private String awardRank;

    /** 嘉奖时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "嘉奖时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date awardTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 审核状态 */
    private String auditState;

    /** 创建人id */
    private Long createById;

    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 修改人id */
    private Long updateById;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 删除状态 */
    private String delFlag;
}
