package yangtz.cs.liu.campus.vo.student;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 学生成绩对象 school_student_achievement
 *
 * @author ruoyi
 * @date 2024-01-08
 */
@Data
public class SchoolStudentAchievementVo
{

    /** 主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 学年 */
    @Excel(name = "学年",combo = {"2018-2019","2019-2020","2020-2021","2021-2022","2022-2023","2023-2024","2024-2025",
            "2025-2026","2026-2027","2027-2028","2028-2029","2029-2030","2030-2031","2031-2032","2032-2033"})
    private String schoolYear;

    /** 学期 */
    @Excel(name = "学期",combo = {"第一学期","第二学期"})
    private String semester;

    /** 届别 */
    @Excel(name = "届别",combo = {"2018","2019","2020","2021","2022","2023","2024","2025","2026","2027","2028","2029","2030","2031","2032","2033"})
    private String year;

    /** 年级 */
    @Excel(name = "年级",combo = {"高一","高二","高三"})
    private String grade;

    /** 班级 */
    @Excel(name = "班级",combo = {"1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16",
            "17","18","19","20","21","22","23","24","25","26","27","28","29","30","31","32","33","34","35","36","37","38","39","40"})
    private String className;

    /** 班级类型 */
    @Excel(name = "班级类型",combo = {"提高班","普通班","音乐班","美术班","体育班","特优班"})
    private String classType;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 语文成绩 */
    @Excel(name = "语文成绩")
    private BigDecimal languageScore;

    /** 数学成绩 */
    @Excel(name = "数学成绩")
    private BigDecimal mathScore;

    /** 英语成绩 */
    @Excel(name = "英语成绩")
    private BigDecimal englishScore;

    /** 物理成绩 */
    @Excel(name = "物理成绩")
    private BigDecimal physicsScore;

    /** 化学成绩 */
    @Excel(name = "化学成绩")
    private BigDecimal chemistryScore;

    /** 生物成绩 */
    @Excel(name = "生物成绩")
    private BigDecimal biologyScore;

    /** 政治成绩 */
    @Excel(name = "政治成绩")
    private BigDecimal politicsScore;

    /** 历史成绩 */
    @Excel(name = "历史成绩")
    private BigDecimal historyScore;

    /** 地理成绩 */
    @Excel(name = "地理成绩")
    private BigDecimal geographyScore;

    /** 专业课名称 */
    @Excel(name = "专业课名称")
    private String specialityName;

    /** 专业课成绩 */
    @Excel(name = "专业课成绩")
    private BigDecimal specialityScore;

    /** 艺体课名称 */
    @Excel(name = "艺体课名称")
    private String eurhythmicsName;

    /** 艺体课成绩 */
    @Excel(name = "艺体课成绩")
    private BigDecimal eurhythmicsScore;

    /** 考试类型 */
    @Excel(name = "考试类型",combo = {"月考","期中","期末","一模","二模","三模","高考"})
    private String examType;

    /** 考试时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "考试时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date examTime;

    /** 考试时间 */
    private String examTime1;

    /** 班主任id */
    private Long classTeacherId;

    /** 班主任 */
    @Excel(name = "班主任")
    private String classTeacher;

    /** 创建人id */
    private Long createById;

    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 修改人id */
    private Long updateById;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 删除状态 */
    private String delFlag;
}
