package yangtz.cs.liu.campus.vo.schoolgrade;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

@Data
public class SchoolGradeMentorVo extends OurBaseEntity {

    private static final long serialVersionUID = 1L;

    /** 老师主键 */
    private Long teacherId;

    /** 年级主键 */
    private Long gradeId;

    /** 职务 */
    private String teacherPost;

    /**
     * 老师头像
     */
    @Excel(name = "头像",cellType = Excel.ColumnType.IMAGE,height = 65)
    private String picUrl;


    @Excel(name = "老师姓名")
    private String teacherName;

    @Excel(name = "班级名称")
    private String className;

    /**
     * 老师电话号码
     */
    @Excel(name = "电话号码")
    private String teacherTel;

    /**
     * 工作编号
     */
    @Excel(name = "工作编号")
    private String teacherCode;

    /**
     * 家庭地址
     */
    @Excel(name = "家庭地址",width = 25)
    private String homeAddress;

    /** 课程名称*/
    @Excel(name = "任课名称")
    private String courseName;

    private Long courseId;

    private String sex;

    private String education;

    /** 类型（1年级部，2学科组长） */
    private String type;

    /** 学科组(1物理学科组，2化学学科组，3生物学科组) */
    private String subGroup;


}
