package yangtz.cs.liu.campus.vo.schoolRewardsPunishments;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

/**
 * 学生违纪导出对象 school_sc_discipline
 *
 * @author ruoyi
 * @date 2023-11-06
 */
@Data
public class SchoolScDisciplineExport {

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 学年 */
    @Excel(name = "学年", combo = {"2018-2019","2019-2020","2020-2021","2021-2022","2022-2023",
                "2023-2024","2024-2025","2025-2026","2026-2027","2027-2028","2028-2029","2029-2030","2030-2031","2031-2032","2032-2033"})
    private String schoolYear;

    /** 学期 */
    @Excel(name = "学期", dictType = "semester_jsdzda")
    private String semester;

    /** 届别 */
    @Excel(name = "届别")
    private String gradeYear;

    /** 年级id */
    private Long gradeId;

    /** 年级 */
    @Excel(name = "年级",dictType = "grade_da")
    private String gradeName;

    /** 班级id */
    private Long classId;

    /** 班级 */
    @Excel(name = "班级")
    private String className;

    /** 班级类型 */
    @Excel(name = "班级类型",dictType = "class_type")
    private String classType;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 性别 */
    @Excel(name = "性别",dictType = "sys_user_sex")
    private String sex;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 班主任id */
    private Long classTeacherId;

    /** 班主任 */
    @Excel(name = "班主任")
    private String classTeacher;

    /** 级部主任id */
    private Long gradeDirectorId;

    /** 级部主任 */
    @Excel(name = "级部主任")
    private String gradeDirector;

    /** 违纪类别（字典） */
    @Excel(name = "违纪行为")
    private String violateType;

    /** 违纪次数（字典） */
    @Excel(name = "违纪次数", dictType = "violate_num")
    private String violateNum;

    /** 处分结果（字典） */
    @Excel(name = "处分结果",dictType = "punish_result")
    private String punishResult;

    /** 处分时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "处分时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date punishTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 审核状态(0未提交，1审核中，2通过，3驳回) */
    @Excel(name = "审核状态", dictType = "audit_state")
    private String auditState;

    /** 申请人id */
    private Long applyId;

    /** 申请人 */
    private String applyName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 创建者 */
    @TableField(fill = FieldFill.INSERT)
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /** 更新者 */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
}
