package yangtz.cs.liu.campus.vo.schoolRewardsPunishments;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

import java.util.Date;
import java.util.List;

@Data
public class SchoolScAwardsVo
{
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 比赛名称 */
    @Excel(name = "比赛名称", needMerge = true)
    private String competitionName;

    /** 主办单位 */
    @Excel(name = "主办单位", needMerge = true)
    private String organizer;

    /** 获奖名称 */
    @Excel(name = "获奖名称", needMerge = true)
    private String awardsName;

    /** 主管部门id */
    private Long competentDeptId;

    /** 主管部门 */
    @Excel(name = "主管部门", needMerge = true)
    private String competentDept;

    /** 获奖级别(字典) */
    @Excel(name = "获奖级别", combo = {"国家级","省部级","市级","县区级","校级","其他"}, readConverterExp = "1=国家级,2=省部级,3=市级,4=县区级,5=校级,6=其他", needMerge = true)
    private String awardsLevel;

    /** 部门主任id */
    private Long deptDirectorId;

    /** 部门主任 */
    @Excel(name = "部门主任", needMerge = true)
    private String deptDirector;

    /** 获奖时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "获奖时间", width = 30, dateFormat = "yyyy-MM-dd", needMerge = true)
    private Date awardsTime;

    /** 获奖类型(字典) */
    @Excel(name = "获奖类型", combo = {"综合类","党建类","师德类","学科类","奥赛类","艺术类","体育类","科创类","作文类","演讲类","绘画类","生源基地类","其他类"},
            readConverterExp = "1=综合类,2=党建类,3=师德类,4=学科类,5=奥赛类,6=艺术类,7=体育类,8=科创类,9=作文类,10=演讲类,11=绘画类,12=生源基地类,13=其他类", needMerge = true)
    private String awardsType;

    /** 备注 */
    @Excel(name = "备注", needMerge = true)
    private String remark;

    /** 审核状态(0未提交，1审核中，2通过，3驳回)*/
    @Excel(name = "审核状态",combo = {"未提交","审核中","通过","驳回"},readConverterExp = "1=未提交,2=审核中,3=通过,4=驳回", needMerge = true)
    private String auditState;

    /** 申请人id */
    private Long applyId;

    /** 申请人 */
    private String applyName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 创建者 */
    @TableField(fill = FieldFill.INSERT)
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /** 更新者 */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

    /** 是否删除 */
    @TableField(fill = FieldFill.INSERT)
    private String delFlag;

    //图片附件
    private List<SchoolAccessory> schoolAccessoryList;

    /** 开始时间 */
    private String startTime;

    /** 结束时间 */
    private String endTime;
}
