package yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 青年教师成长档案对象 school_xsyouth_teacher
 *
 * @author ruoyi
 * @date 2024-01-29
 */
@Data
public class SchoolXsyouthTeacherVo {

    private Integer xh;

    /** 主键id */
    private Long id;

    /** 学年 */
    @Excel(name = "学年", dictType = "yearda")
    private String schoolYear;

    /** 学期 */
    @Excel(name = "学期", dictType = "semester_jsdzda")
    private String semester;

    /** 届别 */
    @Excel(name = "届别", dictType = "rankda")
    private String year;

    /** 年级 */
    @Excel(name = "年级", dictType = "grade_da")
    private String grade;

    /** 学科 */
    @Excel(name = "学科", dictType = "sub_dzdn")
    private String sub;

    /** 班级 */
    @Excel(name = "班级")
    private String className;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 身份证号 */
    private List<String> idCards;

    /** 青年教师培养期 */
    @Excel(name = "青年教师培养期")
    private String incubationPeriod;

    /** 师生同考成绩 */
    @Excel(name = "师生同考成绩")
    private String sameExamResults;

    /** 研做高考题情况 */
    @Excel(name = "研做高考题情况")
    private String situation;

    /** 优质课比赛名称 */
    private String classCompetitionName;

    /** 优质课比赛地址 */
    private String classCompetitionUrl;

    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 删除状态 */
    private String delFlag;

    /** 开始时间 */
    private String startTime;

    /** 结束时间 */
    private String endTime;

}
