package yangtz.cs.liu.campus.vo.schoolInstrument;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolTeacherBorrowDetail;

import java.util.Date;
import java.util.List;

@Data
public class SchoolTeacherBorrowVo extends OurBaseEntity {

    /** 借用人id */
    @Excel(name = "借用人id")
    private Long borrowById;

    /** 借用人 */
    @Excel(name = "借用人")
    private String borrowBy;

    /** 借用学科(1物理，2化学，3生物) */
    @Excel(name = "借用学科(1物理，2化学，3生物)")
    private String borrowSub;

    /** 借用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "借用时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date borrowTime;

    /** 借用状态(0未归还，1已归还，2已申请) */
    @Excel(name = "借用状态(0未归还，1已归还，2已申请)")
    private String borrowState;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 归还时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "归还时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date returnTime;

    /** 备注 */
    private String remark;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    /** 教师借用明细信息 */
    private List<SchoolTeacherBorrowDetail> schoolTeacherBorrowDetailList;
}
