package yangtz.cs.liu.campus.vo.schoolAssetsClaim;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
public class ClaimVo{
    @NotBlank(message = "领用类型不能为空")
    private String claimType;

    @NotNull(message = "资产归属不能为空")
    private Long claimBelong;

    private String claimBelongName;

    @NotNull(message = "领用人不能为空")
    private Long collectBy;

    @NotNull(message = "领用时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date collectDate;

    List<AssetsClaimDetailsVo> list;
}
