package yangtz.cs.liu.campus.vo.schoolAssets;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 【请填写功能名称】对象 school_assets_out
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@Data
public class AssetsOutVo
{
    private static final long serialVersionUID = 1L;

    private Long id;

    /** 资产id */
    @Excel(name = "资产id")
    @NotNull(message = "资产id不能为空")
    private Long assetsId;

    /** 资产name*/
    @Excel(name = "资产name")
    @NotNull(message = "资产name")
    private String assetsName;


    /** 出库数量 */
    @Excel(name = "出库数量")
    @NotNull(message = "出库数量不能为空")
    private Integer outNumbers;

    /** 出库日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出库日期", width = 30, dateFormat = "yyyy-MM-dd")
    @NotNull(message = "出库日期不能为空")
    private Date outDate;

    /** 出库类型(0领用 1盘减 2报废 3捐赠 4损坏) */
    @Excel(name = "出库类型(0领用 1盘减 2报废 3捐赠 4损坏)")
    @NotNull(message = "出库类型不能为空")
    private String outType;


    /** 领用人 */
    @Excel(name = "领用人")
    private Long outBy;

    /** outByName */
    @Excel(name = "领用人姓名")
    private String outByName;

    /** remark */
    @Excel(name = "备注")
    private String remark;


}
