package yangtz.cs.liu.campus.vo.schoolAnnualAssessment;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class SchoolAnnualAssessmentVo {

    /** 主键id */
    private Long id;

    @Excel(name = "序号")
    private Integer xh;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 年度 */
    @Excel(name = "年度",combo = {"2018","2019","2020","2021","2022","2023","2024","2025","2026","2027","2028","2029","2030","2031","2032","2033"})
    private Integer year;

    /** 身份证号集合 */
    private List<String> idCards;

    /** 身份证 */
    private String idCard;

    /** 考核结果(1优秀、2合格、3不定等次、4不予考核、5不合格) */
    @Excel(name = "考核结果", readConverterExp = "1=优秀,2=合格,3=不定等次,4=不予考核,5=不合格,6=记功,7=嘉奖", combo = {"记功","嘉奖","优秀","合格","不定等次","不予考核","不合格"})
    private String checkResult;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 删除状态 */
    private String delFlag;
}
