package yangtz.cs.liu.campus.vo.recruit;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import java.util.Date;
import lombok.Data;

@Data
public class RecruitExamScoreVo extends OurBaseEntity {
    private Long examId;
    private String auditStatus;
    @Excel(name = "序号")
    private int xh;

    private String photo;
    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 姓名 */
    @Excel(name = "姓名")
    private String studentName;

    /** 学籍号 */
//    @Excel(name = "学籍号")
    private String studentNumber;

    /** 初中学校id */
    private Long juniorId;
    //    @Excel(name = "初中学校")
    private String schoolName;

    /** 测试项目id */
    private Long testId;
    @Excel(name = "测试项目")
    private String project;

    /** 性别（0=男，1=女） */
    @Excel(name = "性别", readConverterExp = "0=男,1=女")
    private String sex;

    /** 身高（单位厘米） */
    private double height;

    /** 体重（单位千克） */
    private double weight;

    /** 联系方式1 */
    private String telephone1;

    /** 联系方式2 */
    private String telephone2;

    /** 准考证号 */
    @Excel(name = "准考证号")
    private String examNumber;

    /** 分组 */
    @Excel(name = "分组")
    private String inGroup;

    /** 考试日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "考试日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date examDate;

    /** 考试时间 */
    @Excel(name = "考试时间", dateFormat = "HH:mm")
    private String examTime;

    /** 考试地点 */
    @Excel(name = "考试地点")
    private String examAddress;

    /** 成绩 */
    @Excel(name = "成绩")
    private String score;

    /** 结果 */
    @Excel(name = "结果")
    private String result;

    /** 资格线 */
    @Excel(name = "资格线")
    private String passScore;
}
