package yangtz.cs.liu.campus.vo.recruit;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

@Data
public class RecruitEduStudentVo extends OurBaseEntity {

  /**
   * 考试id
   */
  @Excel(name = "考试id")
  private Long examId;

  /**
   * 学生id
   */
  @Excel(name = "学生id")
  private Long studentId;

  /**
   * 审核状态（只存在教育局信息时该字段没有值，0=驳回，1=通过，2 =退回修改,3=待审核）
   */
  @Excel(name = "审核状态", readConverterExp = "只=存在教育局信息时该字段没有值，0=驳回，1=通过，2,==退回修改,3=待审核")
  private String auditStatus;

  /**
   * 匹配状态（0=不匹配，1= 匹配，2=无教育局信息，3=未报名）
   */
  @Excel(name = "匹配状态", readConverterExp = "0=不匹配，1=匹配，2=无教育局信息，3=未报名")
  private String matchStatus;

  /**
   * 身份证号码
   */
  @Excel(name = "身份证号码")
  private String infoIdCard;

  /***********学生自己的报名信息***********/

  /**
   * 姓名
   */
  @Excel(name = "姓名")
  private String studentName;

  /**
   * 身份证号
   */
  @Excel(name = "身份证号")
  private String idCard;

  /**
   * 学籍号
   */
  @Excel(name = "学籍号")
  private String studentNumber;

  /**
   * 初中学校id
   */
  @Excel(name = "初中学校id")
  private Long juniorId;
  private String schoolName;

  /**
   * 测试项目id
   */
  @Excel(name = "测试项目id")
  private Long testId;
  private String project;

  /**
   * 性别（0=男，1=女）
   */
  @Excel(name = "性别", readConverterExp = "0==男，1=女")
  private String sex;

  /**
   * 照片
   */
  @Excel(name = "照片")
  private String photo;

  /***************教育局信息***************/

  /**
   * 身份证号
   */
  @Excel(name = "身份证号")
  private String eduIdCard;

  /**
   * 姓名
   */
  @Excel(name = "姓名")
  private String eduStudentName;

  /** 学籍号 */
//    @Excel(name = "学籍号")
//    private String eduStudentNumber;

  /** 初中学校id */
//    @Excel(name = "初中学校id")
//    private Long eduJuniorId;

  /** 初中学校 */
//    @Excel(name = "初中学校")
//    private String eduSchoolName;

  /**
   * 测试项目id
   */
  @Excel(name = "测试项目id")
  private Long eduTestId;

  /**
   * 测试项目
   */
  @Excel(name = "测试项目")
  private String eduProject;

  /**
   * 性别（0=男，1=女）
   */
  @Excel(name = "性别", readConverterExp = "0=男，1=女")
  private String eduSex;
}
