package yangtz.cs.liu.campus.vo.recruit;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

@Data
public class RecruitAndEduStudentVo extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /** 姓名 */
    @Excel(name = "姓名")
    private String studentName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 学籍号 */
    @Excel(name = "学籍号")
    private String studentNumber;

    /** 初中学校id */
    @Excel(name = "初中学校id")
    private Long juniorId;
    private String schoolName;

    /** 测试项目id */
    @Excel(name = "测试项目id")
    private Long testId;
    private String project;

    /** 性别（0=男，1=女） */
    @Excel(name = "性别", readConverterExp = "0==男，1=女")
    private String sex;

    /** 身高（单位厘米） */
    @Excel(name = "身高", readConverterExp = "单=位厘米")
    private double height;

    /** 体重（单位千克） */
    @Excel(name = "体重", readConverterExp = "单=位千克")
    private double weight;

    /** 联系方式1 */
    @Excel(name = "联系方式1")
    private String telephone1;

    /** 联系方式2 */
    @Excel(name = "联系方式2")
    private String telephone2;

    /** 照片 */
    @Excel(name = "照片")
    private String photo;


    /***************教育局信息***************/

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String eduIdCard;

    /** 姓名 */
    @Excel(name = "姓名")
    private String eduStudentName;

    /** 学籍号 */
    @Excel(name = "学籍号")
    private String eduStudentNumber;

    /** 初中学校id */
    @Excel(name = "初中学校id")
    private Long eduJuniorId;

    /** 初中学校 */
    @Excel(name = "初中学校")
    private String eduSchoolName;

    /** 测试项目id */
    @Excel(name = "测试项目id")
    private Long eduTestId;

    /** 测试项目 */
    @Excel(name = "测试项目")
    private String eduProject;

    /** 性别（0=男，1=女） */
    @Excel(name = "性别", readConverterExp = "0=男，1=女")
    private String eduSex;
}
