package yangtz.cs.liu.campus.vo.purchase;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class PurchaseVo extends OurBaseEntity {
    /**
     * 标题
     */
    @NotBlank(message = "标题不能为空")
    private String purchaseName;

    /**
     * 申请部门
     */
    @NotNull(message = "申请部门不能为空")
    private Long deptId;

    /**
     * 申请部门名称
     */
    @NotBlank(message = "申请部门名称不能为空")
    private String deptName;

    /**
     * 期望日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date expectedDate;

    /**
     * 批复预算名称
     */
    @NotBlank(message = "批复预算名称不能为空")
    private String budgetName;

    /**
     * 批复预算ID
     */
    @NotNull(message = "批复预算ID不能为空")
    private Long budgetId;

    /**
     * 采购金额
     */
    @NotNull(message = "采购金额不能为空")
    private BigDecimal purchaseMoney;

    /**
     * 实际采购费用
     */
    private BigDecimal sjPurchaseMoney;

    /**
     * 采购说明
     */
    private String remark;

    /**
     * 审批人id1
     */
    @NotNull(message = "分管处室领导不能为空")
    private Long handUserId1;

    /**
     * 审批人名字1
     */
    private String handUserName1;

    /**
     * 审批人id2
     */
    @NotNull(message = "财务领导不能为空")
    private Long handUserId2;

    /**
     * 审批人名字2
     */
    private String handUserName2;

    /**
     * 申请人id
     */
    private Long applyId;

    /**
     * 申请人姓名
     */
    private String applyUser;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date applyTime;

    /**
     * 流程实例ID
     */
    private String instanceId;

    /**
     * 状态
     */
    private String state;

    /**
     * 提交状态（1已提交，0未提交）
     */
    private String tjzt;

    /**子表数据*/
    List<SchoolPurchaseDetailsVo> list;
}
