package yangtz.cs.liu.campus.vo.device;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import java.util.Date;

@Data
public class DeviceListVo {

    private Long id;

    /** 设备编码 */
    @Excel(name = "设备编码")
    private String deviceCode;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 设备类型 */
    @Excel(name = "设备类型")
    private String deviceType;

    /** 设备状态 */
    @Excel(name = "设备状态")
    private String deviceState;

    /** 启用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "启用时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startDate;

    /** 是否删除 */
    @TableField(fill = FieldFill.INSERT)
    private String delFlag;

    /** 供应商 */
    @Excel(name = "供应商")
    private String supplier;

    /** 规格型号 */
    @Excel(name = "规格型号")
    private String model;

    /** 出场日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出场日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date factoryDate;

    /** 质保期 */
    @Excel(name = "质保期")
    private String qualityTime;

}
