package yangtz.cs.liu.campus.vo.conference;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class SchoolConferenceVO {

    private Long id;
    /** 会议室 */
    private Long areaId;
    private String areaName;

    @Excel(name = "会议室详情")
    private Long detailId;
    private String areaNo;

    /** 会议名称 */
    private String conferenceName;

    /** 会议时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 附件路径 */
    private String conferenceDataUrl;

    @Excel(name = "会议数据名称")
    private String conferenceDataName;

    /** 会议纪要 */
    @Excel(name = "会议纪要")
    private String conferenceSummary;
}
