package yangtz.cs.liu.campus.vo.assetsType;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.ruoyi.common.core.domain.TreeSelect;
import com.ruoyi.common.core.domain.entity.SysDept;
import lombok.Data;
import yangtz.cs.liu.campus.domain.assetsType.SchoolAssetsType;

import java.util.List;
import java.util.stream.Collectors;

@Data
public class TypeTree {

    /** 节点ID */
    private Long id;

    /** 节点名称 */
    private String label;

    /** 子节点 */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<TypeTree> children;

    public TypeTree(SchoolAssetsTypeVo type)
    {
        this.id = type.getId();
        this.label = type.getTypeName();
        this.children = type.getChildren().stream().map(TypeTree::new).collect(Collectors.toList());
    }

}
