package yangtz.cs.liu.campus.vo.area;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import java.util.Date;

@Data
public class AreaApplyVo extends ProcessBaseEntity {

        private Long id;
        /** 场地 */
        private Long areaId;
        private String  areaName;

        private String  title;
        private Long detailId;
        /** 房间号 */
        private String  areaNo;

        /** 开始使用时间 */
        @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
        @Excel(name = "开始使用时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
        private Date startTime;

        /** 结束使用时间 */
        @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
        @Excel(name = "结束使用时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
        private Date endTime;

        /** 状态 */
        private String state;

        /** 申请原因 */
        @Excel(name = "申请原因")
        private String reason;

        /** 流程id */
        @Excel(name = "流程id")
        private String instanceId;

        /** 创建者 */
        @Excel(name = "创建者")
        private String createBy;

        /** 申请人 */
        @Excel(name = "申请人")
        private String applyUser;

        /** 申请时间 */
        @JsonFormat(pattern = "yyyy-MM-dd")
        @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
        private Date applyTime;

        private String roleKey;
        private String roleName;
    }

