package yangtz.cs.liu.campus.vo.area;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import javax.validation.constraints.NotBlank;
import java.util.Date;

@Data
public class AreaApplyTodoVo extends ProcessBaseEntity {

    /** title */
    @NotBlank(message = "title")
    @Excel(name = "title")
    private String title;

    /** reason */
    @NotBlank(message = "reason")
    @Excel(name = "reason")
    private String reason;

    /** startTime */
    @Excel(name = "startTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /** endTime */
    @Excel(name = "endTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 申请人id */
    @Excel(name = "申请人id")
    private Long applyId;

    /** 申请人 */
    @Excel(name = "申请人")
    private String applyUser;

    /** 申请时间 */
    @Excel(name = "申请时间")
    private Date applyTime;

    /** 状态（0通过，1驳回） */
    @Excel(name = "状态", readConverterExp = "0=通过，1驳回")
    private Integer state;

    /** 流程实例ID */
    @Excel(name = "流程实例ID")
    private String instanceId;


}
