package yangtz.cs.liu.campus.service.training;

import java.util.List;
import yangtz.cs.liu.campus.domain.training.Training;

/**
 * 培训情况Service接口
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public interface ITrainingService
{
    /**
     * 查询培训情况
     *
     * @param id 培训情况主键
     * @return 培训情况
     */
    public Training selectTrainingById(Long id);

    /**
     * 查询培训情况列表
     *
     * @param training 培训情况
     * @return 培训情况集合
     */
    public List<Training> selectTrainingList(Training training);

    /**
     * 新增培训情况
     *
     * @param training 培训情况
     * @return 结果
     */
    public int insertTraining(Training training);

    /**
     * 修改培训情况
     *
     * @param training 培训情况
     * @return 结果
     */
    public int updateTraining(Training training);

    /**
     * 批量删除培训情况
     *
     * @param ids 需要删除的培训情况主键集合
     * @return 结果
     */
    public int deleteTrainingByIds(Long[] ids);

    /**
     * 删除培训情况信息
     *
     * @param id 培训情况主键
     * @return 结果
     */
    public int deleteTrainingById(Long id);
}
