package yangtz.cs.liu.campus.service.student;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.office.SchoolOfficePurchase;
import yangtz.cs.liu.campus.domain.student.SchoolStudentLeave;
import yangtz.cs.liu.campus.vo.office.OfficeTodoListVO;
import yangtz.cs.liu.campus.vo.student.StudentLeaveVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherOvertimeVO;
import yangtz.cs.liu.wechat.vo.common.WorkFlowVo;
import yangtz.cs.liu.wechat.vo.student.SchoolStudentLeaveVo;

import java.util.List;
import java.util.Map;

public interface ISchoolStudentLeaveService extends IService<SchoolStudentLeave> {

    List<StudentLeaveVO> queryList(String submitState, StudentLeaveVO studentLeave);

    /**
     * 提交学生请假申请
     */
    int submitApply(SchoolStudentLeave schoolStudentLeave, String username, String key, Map<String, Object> variables);

    /**
     * 待办列表
     *
     * @param entity
     * @param userId
     * @return
     */
    List<StudentLeaveVO> findTodoTasks(String key, SchoolStudentLeave entity, String userId);

    /**
     * 已办列表
     *
     * @param key
     * @param entity
     * @param userId
     * @return
     */
    List<StudentLeaveVO> findDoneTasks(String key, SchoolStudentLeave entity, String userId);

    /**
     * 班主任个人任务列表
     *
     * @param key
     * @param entity
     * @param userId
     * @return
     */
    List<StudentLeaveVO> findHeaderTasks(String key, SchoolStudentLeave entity, String userId);


    /**
     * @param taskId
     * @param schoolStudentLeave 销假
     * @author lyric
     * @date 2022/10/28 10:44
     */
    void cancelLeave(String taskId, SchoolStudentLeave schoolStudentLeave);
    void cancel(String taskId, String instanceId, SchoolStudentLeave schoolStudentLeave);

    /**
     * 根据请假总时长判断用户是否选择对应节点的审批人
     * */
    void judgeHandUser(SchoolStudentLeave schoolStudentLeave);

    SchoolStudentLeaveVo getInfo(Long studentId);

    List<StudentLeaveVO> findTasks(String key, String userId);

    WorkFlowVo stduntLeavFlows(Long id);

    //获取学生请假列表
    List<SchoolStudentLeave> gradeList(List<Long> idList, SchoolStudentLeave entity);
}
