package yangtz.cs.liu.campus.service.student;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.student.SchoolStudentAward;
import yangtz.cs.liu.campus.vo.student.SchoolStudentAwardVo;

/**
 * 学生嘉奖Service接口
 *
 * @author ruoyi
 * @date 2024-01-08
 */
public interface ISchoolStudentAwardService extends IService<SchoolStudentAward>
{
    /**
     * 查询学生嘉奖
     *
     * @param id 学生嘉奖主键
     * @return 学生嘉奖
     */
    public SchoolStudentAward selectSchoolStudentAwardById(Long id);

    /**
     * 查询学生嘉奖列表
     *
     * @param schoolStudentAward 学生嘉奖
     * @return 学生嘉奖集合
     */
    public List<SchoolStudentAward> selectSchoolStudentAwardList(SchoolStudentAward schoolStudentAward);

    /**
     * 新增学生嘉奖
     *
     * @param schoolStudentAward 学生嘉奖
     * @return 结果
     */
    public int insertSchoolStudentAward(SchoolStudentAward schoolStudentAward);

    /**
     * 修改学生嘉奖
     *
     * @param schoolStudentAward 学生嘉奖
     * @return 结果
     */
    public int updateSchoolStudentAward(SchoolStudentAward schoolStudentAward);

    /**
     * 批量删除学生嘉奖
     *
     * @param ids 需要删除的学生嘉奖主键集合
     * @return 结果
     */
    public int deleteSchoolStudentAwardByIds(Long[] ids);

    /**
     * 删除学生嘉奖信息
     *
     * @param id 学生嘉奖主键
     * @return 结果
     */
    public int deleteSchoolStudentAwardById(Long id);

    /**
     * 提交审核
     * @param schoolStudentAward
     * @return
     */
    int submit(SchoolStudentAward schoolStudentAward);

    /**
     * 校验数据
     * @param list
     */
    void checkImport(List<SchoolStudentAwardVo> list);

    /**
     * 导入数据
     * @param list
     * @return
     */
    String importExamDetail(List<SchoolStudentAwardVo> list);

    /**
     * 查询已通过学生嘉奖列表
     * @param schoolStudentAward
     * @return
     */
    List<SchoolStudentAward> selectSchoolStudentAwardListTg(SchoolStudentAward schoolStudentAward);
}
