package yangtz.cs.liu.campus.service.student;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.student.SchoolStudentAchievement;
import yangtz.cs.liu.campus.vo.student.SchoolStudentAchievementVo;

/**
 * 学生成绩Service接口
 *
 * @author ruoyi
 * @date 2024-01-08
 */
public interface ISchoolStudentAchievementService extends IService<SchoolStudentAchievement>
{
    /**
     * 查询学生成绩
     *
     * @param id 学生成绩主键
     * @return 学生成绩
     */
    public SchoolStudentAchievement selectSchoolStudentAchievementById(Long id);

    /**
     * 查询学生成绩列表
     *
     * @param schoolStudentAchievement 学生成绩
     * @return 学生成绩集合
     */
    public List<SchoolStudentAchievement> selectSchoolStudentAchievementList(SchoolStudentAchievement schoolStudentAchievement);

    /**
     * 新增学生成绩
     *
     * @param schoolStudentAchievement 学生成绩
     * @return 结果
     */
    public int insertSchoolStudentAchievement(SchoolStudentAchievement schoolStudentAchievement);

    /**
     * 修改学生成绩
     *
     * @param schoolStudentAchievement 学生成绩
     * @return 结果
     */
    public int updateSchoolStudentAchievement(SchoolStudentAchievement schoolStudentAchievement);

    /**
     * 批量删除学生成绩
     *
     * @param ids 需要删除的学生成绩主键集合
     * @return 结果
     */
    public int deleteSchoolStudentAchievementByIds(Long[] ids);

    /**
     * 删除学生成绩信息
     *
     * @param id 学生成绩主键
     * @return 结果
     */
    public int deleteSchoolStudentAchievementById(Long id);

    /**
     * 校验数据
     * @param list
     */
    void checkImport(List<SchoolStudentAchievementVo> list);

    /**
     * 新增数据
     * @param list
     * @return
     */
    String importExamDetail(List<SchoolStudentAchievementVo> list);
}
