package yangtz.cs.liu.campus.service.schoolbudget;

import com.baomidou.mybatisplus.extension.service.IService;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolbudget.SchoolBudget;
import yangtz.cs.liu.campus.vo.schoolbudget.SchoolBudgetVo;

import java.io.IOException;
import java.util.List;

/**
 * 预算项目Service接口
 *
 * @author wengxiu
 * @date 2023-01-05
 */
public interface ISchoolBudgetService extends IService<SchoolBudget>
{
    /**
     * 查询预算项目
     *
     * @param id 预算项目主键
     * @return 预算项目
     */
    SchoolBudgetVo selectSchoolBudgetById(Long id);

    /**
     * 查询预算项目列表(按科室过滤)
     *
     * @param schoolBudget 预算项目
     * @return 预算项目集合
     */
    List<SchoolBudgetVo> selectSchoolBudgetList(SchoolBudget schoolBudget);

    /**查全部*/
    List<SchoolBudgetVo> getList(SchoolBudget schoolBudget);

    /**
     * 查详情
     * */
    SchoolBudgetVo queryInfo(Long id);

    /**
     * 新增预算项目
     *
     * @param schoolBudget 预算项目
     * @return 结果
     */
    int insertSchoolBudget(SchoolBudgetVo schoolBudget);

    /**
     * 修改预算项目
     * @return 结果
     */
    int updateSchoolBudget(SchoolBudgetVo schoolBudgetVo);

    Boolean checkIsExist(SchoolBudgetVo schoolBudgetVo);

    List<SchoolBudgetVo> selectExportList(SchoolBudget schoolBudget);

    String importSchoolBudgetVoList(List<SchoolBudgetVo> list);

    //导入数据校验
    void checkImport(List<SchoolBudgetVo> list);

}
