package yangtz.cs.liu.campus.service.schoolSecurity;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVideoConsultExternal;
import yangtz.cs.liu.campus.vo.schoolSecurity.SchoolVideoConsultExternalVo;

import java.util.List;

/**
 * 监控调阅（外部）Service接口
 *
 * @author ruoyi
 * @date 2023-09-11
 */
public interface ISchoolVideoConsultExternalService extends IService<SchoolVideoConsultExternal>
{

    /**
     * 查询监控调阅（外部）
     *
     * @param id 监控调阅（外部）主键
     * @return 监控调阅（外部）
     */
    public SchoolVideoConsultExternalVo selectSchoolVideoConsultExternalById(Long id);

    /**
     * 查询监控调阅（外部）列表
     *
     * @param schoolVideoConsultExternalVo 监控调阅（外部）
     * @return 监控调阅（外部）集合
     */
    public List<SchoolVideoConsultExternalVo> selectSchoolVideoConsultExternalList(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo);

    /**
     * 新增监控调阅（外部）
     *
     * @param schoolVideoConsultExternalVo 监控调阅（外部）
     * @return 结果
     */
    public int insertSchoolVideoConsultExternal(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo);

    /**
     * 修改监控调阅（外部）
     *
     * @param schoolVideoConsultExternalVo 监控调阅（外部）
     * @return 结果
     */
    public int updateSchoolVideoConsultExternal(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo);

    /**
     * 批量删除监控调阅（外部）
     *
     * @param ids 需要删除的监控调阅（外部）主键集合
     * @return 结果
     */
    public int deleteSchoolVideoConsultExternalByIds(Long[] ids);

    /**
     * 删除监控调阅（外部）信息
     *
     * @param id 监控调阅（外部）主键
     * @return 结果
     */
    public int deleteSchoolVideoConsultExternalById(Long id);
}
