package yangtz.cs.liu.campus.service.schoolRewardsPunishments;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteachingAchievements;
import yangtz.cs.liu.campus.domain.schoolRewardsPunishments.SchoolScDiscipline;
import yangtz.cs.liu.campus.vo.schoolRewardsPunishments.SchoolScDisciplineVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 学生违纪Service接口
 *
 * @author ruoyi
 * @date 2023-11-06
 */
public interface ISchoolScDisciplineService extends IService<SchoolScDiscipline>
{
    /**
     * 查询学生违纪
     *
     * @param id 学生违纪主键
     * @return 学生违纪
     */
    public SchoolScDisciplineVo selectSchoolScDisciplineById(Long id);

    /**
     * 查询学生违纪列表
     *
     * @param schoolScDiscipline 学生违纪
     * @return 学生违纪集合
     */
    public List<SchoolScDiscipline> selectSchoolScDisciplineList(SchoolScDiscipline schoolScDiscipline);

    /**
     * 查询学生违纪列表(查看已通过)
     *
     * @param schoolScDiscipline 学生违纪
     * @return 学生违纪集合
     */
    public List<SchoolScDiscipline> selectSchoolScDisciplineListTg(SchoolScDiscipline schoolScDiscipline);

    /**
     * 新增学生违纪
     *
     * @param schoolScDisciplineVo 学生违纪
     * @return 结果
     */
    public int insertSchoolScDiscipline(SchoolScDisciplineVo schoolScDisciplineVo);

    /**
     * 修改学生违纪
     *
     * @param schoolScDisciplineVo 学生违纪
     * @return 结果
     */
    public int updateSchoolScDiscipline(SchoolScDisciplineVo schoolScDisciplineVo);

    /**
     * 批量删除学生违纪
     *
     * @param ids 需要删除的学生违纪主键集合
     * @return 结果
     */
    public int deleteSchoolScDisciplineByIds(Long[] ids);

    /**
     * 删除学生违纪信息
     *
     * @param id 学生违纪主键
     * @return 结果
     */
    public int deleteSchoolScDisciplineById(Long id);

    /**
     * 获取最新三个年级
     * @return
     */
    List<Map<String,Object>> getGrade();

    /**
     * 根据年级获取班级
     * @param gradeId
     * @return
     */
    List<Map<String,Object>> getClassList(Long gradeId);

    /**
     * 下载模板
     * @param response
     */
    void importTemplate(HttpServletResponse response);

    /**
     * 校验数据
     * @param list
     */
    void checkImport(List<SchoolScDisciplineVo> list);

    /**
     * 导入数据
     * @param list
     * @return
     */
    String importData(List<SchoolScDisciplineVo> list);
}
