package yangtz.cs.liu.campus.service.schoolRewardsPunishments;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolRewardsPunishments.SchoolScAwards;
import yangtz.cs.liu.campus.vo.schoolRewardsPunishments.SchoolScAwardsVo;

import java.util.List;

/**
 * 学校获奖Service接口
 *
 * @author ruoyi
 * @date 2023-11-06
 */
public interface ISchoolScAwardsService extends IService<SchoolScAwards>
{
    /**
     * 查询学校获奖
     *
     * @param id 学校获奖主键
     * @return 学校获奖
     */
    public SchoolScAwardsVo selectSchoolScAwardsById(Long id);

    /**
     * 查询学校获奖列表
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 学校获奖集合
     */
    public List<SchoolScAwardsVo> selectSchoolScAwardsList(SchoolScAwardsVo schoolScAwardsVo);

    /**
     * 查询学校获奖列表(查看已通过)
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 学校获奖集合
     */
    public List<SchoolScAwardsVo> selectSchoolScAwardsListTg(SchoolScAwardsVo schoolScAwardsVo);

    /**
     * 新增学校获奖
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 结果
     */
    public int insertSchoolScAwards(SchoolScAwardsVo schoolScAwardsVo);

    /**
     * 修改学校获奖
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 结果
     */
    public int updateSchoolScAwards(SchoolScAwardsVo schoolScAwardsVo);

    /**
     * 批量删除学校获奖
     *
     * @param ids 需要删除的学校获奖主键集合
     * @return 结果
     */
    public int deleteSchoolScAwardsByIds(Long[] ids);

    /**
     * 删除学校获奖信息
     *
     * @param id 学校获奖主键
     * @return 结果
     */
    public int deleteSchoolScAwardsById(Long id);

    /**
     * 提交
     * @param schoolScAwards
     * @return
     */
    int submit(SchoolScAwards schoolScAwards);
}
