package yangtz.cs.liu.campus.service.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.entity.SysUser;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.schoolAnnualAssessment.SchoolAnnualAssessment;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteachingAchievements;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXteachingAchievementsVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 教学成绩Service接口
 *
 * @author ruoyi
 * @date 2023-12-06
 */
public interface ISchoolXteachingAchievementsService extends IService<SchoolXteachingAchievements>
{
    /**
     * 查询教学成绩
     *
     * @param id 教学成绩主键
     * @return 教学成绩
     */
    public SchoolXteachingAchievementsVo selectSchoolXteachingAchievementsById(Long id);

    /**
     * 查询教学成绩列表
     *
     * @param schoolXteachingAchievementsVo 教学成绩
     * @return 教学成绩集合
     */
    public List<SchoolXteachingAchievementsVo> selectSchoolXteachingAchievementsList(SchoolXteachingAchievementsVo schoolXteachingAchievementsVo);

    /**
     * 新增教学成绩
     *
     * @param schoolXteachingAchievements 教学成绩
     * @return 结果
     */
    public int insertSchoolXteachingAchievements(SchoolXteachingAchievements schoolXteachingAchievements);

    /**
     * 修改教学成绩
     *
     * @param schoolXteachingAchievements 教学成绩
     * @return 结果
     */
    public int updateSchoolXteachingAchievements(SchoolXteachingAchievements schoolXteachingAchievements);

    /**
     * 批量删除教学成绩
     *
     * @param ids 需要删除的教学成绩主键集合
     * @return 结果
     */
    public int deleteSchoolXteachingAchievementsByIds(Long[] ids);

    /**
     * 删除教学成绩信息
     *
     * @param id 教学成绩主键
     * @return 结果
     */
    public int deleteSchoolXteachingAchievementsById(Long id);

    /**
     * 获取所有用户
     * @return
     */
    List<Map<String,Object>> getUserList(SysUser sysUser);

    /**
     * 下载模板
     * @param response
     */
    void importTemplate(HttpServletResponse response);

    /**
     * 校验导入数据
     * @param list
     */
    void checkImport(List<SchoolXteachingAchievements> list);

    /**
     * 导入数据
     * @param list
     * @return
     */
    String importData(List<SchoolXteachingAchievements> list);

    /**
     * 查询本部门下所有教师id
     * @param deptId
     * @return
     */
    List<Long> getUserIdsByDeptId(Long deptId);

    /**
     * 查询本部门下所有教师手机号
     * @param deptId
     * @return
     */
    List<String> getUserPhonesByDeptId(Long deptId);

    /**
     * 查询所有级部id
     * @return
     */
    List<Long> getJbDeptId();

    /**
     * 查询科室id
     * @return
     */
    List<Long> getKsDeptId();
}
