package yangtz.cs.liu.campus.service.schoolNewTeacherDzdn;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXsyouthTeacher;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteachingAchievements;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXsyouthTeacherDrVo;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXsyouthTeacherVo;

/**
 * 青年教师成长档案Service接口
 *
 * @author ruoyi
 * @date 2024-01-29
 */
public interface ISchoolXsyouthTeacherService extends IService<SchoolXsyouthTeacher>
{
    /**
     * 查询青年教师成长档案
     *
     * @param id 青年教师成长档案主键
     * @return 青年教师成长档案
     */
    public SchoolXsyouthTeacher selectSchoolXsyouthTeacherById(Long id);

    /**
     * 查询青年教师成长档案列表
     *
     * @param schoolXsyouthTeacherVo 青年教师成长档案
     * @return 青年教师成长档案集合
     */
    public List<SchoolXsyouthTeacher> selectSchoolXsyouthTeacherList(SchoolXsyouthTeacherVo schoolXsyouthTeacherVo);

    /**
     * 新增青年教师成长档案
     *
     * @param schoolXsyouthTeacher 青年教师成长档案
     * @return 结果
     */
    public int insertSchoolXsyouthTeacher(SchoolXsyouthTeacher schoolXsyouthTeacher);

    /**
     * 修改青年教师成长档案
     *
     * @param schoolXsyouthTeacher 青年教师成长档案
     * @return 结果
     */
    public int updateSchoolXsyouthTeacher(SchoolXsyouthTeacher schoolXsyouthTeacher);

    /**
     * 批量删除青年教师成长档案
     *
     * @param ids 需要删除的青年教师成长档案主键集合
     * @return 结果
     */
    public int deleteSchoolXsyouthTeacherByIds(Long[] ids);

    /**
     * 删除青年教师成长档案信息
     *
     * @param id 青年教师成长档案主键
     * @return 结果
     */
    public int deleteSchoolXsyouthTeacherById(Long id);

    /**
     * 校验数据
     * @param list
     */
    void checkImport(List<SchoolXsyouthTeacherDrVo> list);

    /**
     * 数据导入
     * @param list
     * @return
     */
    String importData(List<SchoolXsyouthTeacherDrVo> list);
}
