package yangtz.cs.liu.campus.service.schoolNewTeacherDzdn;

import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXlectureAwards;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXlectureAwardsVo;

import java.util.List;

/**
 * 讲课获奖Service接口
 *
 * @author ruoyi
 * @date 2023-12-06
 */
public interface ISchoolXlectureAwardsService
{
    /**
     * 查询讲课获奖
     *
     * @param id 讲课获奖主键
     * @return 讲课获奖
     */
    public SchoolXlectureAwardsVo selectSchoolXlectureAwardsById(Long id);

    /**
     * 查询讲课获奖列表
     *
     * @param schoolXlectureAwardsVo 讲课获奖
     * @return 讲课获奖集合
     */
    public List<SchoolXlectureAwardsVo> selectSchoolXlectureAwardsList(SchoolXlectureAwardsVo schoolXlectureAwardsVo);

    /**
     * 新增讲课获奖
     *
     * @param schoolXlectureAwards 讲课获奖
     * @return 结果
     */
    public int insertSchoolXlectureAwards(SchoolXlectureAwards schoolXlectureAwards);

    /**
     * 修改讲课获奖
     *
     * @param schoolXlectureAwards 讲课获奖
     * @return 结果
     */
    public int updateSchoolXlectureAwards(SchoolXlectureAwards schoolXlectureAwards);

    /**
     * 批量删除讲课获奖
     *
     * @param ids 需要删除的讲课获奖主键集合
     * @return 结果
     */
    public int deleteSchoolXlectureAwardsByIds(Long[] ids);

    /**
     * 删除讲课获奖信息
     *
     * @param id 讲课获奖主键
     * @return 结果
     */
    public int deleteSchoolXlectureAwardsById(Long id);

    /**
     * 审核
     * @param schoolXlectureAwards
     * @return
     */
    int audit(SchoolXlectureAwards schoolXlectureAwards);
}
