package yangtz.cs.liu.campus.service.schoolNewTeacherDzdn;

import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXacademicWorks;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXacademicWorksVo;

import java.util.List;

/**
 * 论文著作Service接口
 *
 * @author ruoyi
 * @date 2023-12-06
 */
public interface ISchoolXacademicWorksService
{
    /**
     * 查询论文著作
     *
     * @param id 论文著作主键
     * @return 论文著作
     */
    public SchoolXacademicWorksVo selectSchoolXacademicWorksById(Long id);

    /**
     * 查询论文著作列表
     *
     * @param schoolXacademicWorksVo 论文著作
     * @return 论文著作集合
     */
    public List<SchoolXacademicWorksVo> selectSchoolXacademicWorksList(SchoolXacademicWorksVo schoolXacademicWorksVo);

    /**
     * 新增论文著作
     *
     * @param schoolXacademicWorks 论文著作
     * @return 结果
     */
    public int insertSchoolXacademicWorks(SchoolXacademicWorks schoolXacademicWorks);

    /**
     * 修改论文著作
     *
     * @param schoolXacademicWorks 论文著作
     * @return 结果
     */
    public int updateSchoolXacademicWorks(SchoolXacademicWorks schoolXacademicWorks);

    /**
     * 批量删除论文著作
     *
     * @param ids 需要删除的论文著作主键集合
     * @return 结果
     */
    public int deleteSchoolXacademicWorksByIds(Long[] ids);

    /**
     * 删除论文著作信息
     *
     * @param id 论文著作主键
     * @return 结果
     */
    public int deleteSchoolXacademicWorksById(Long id);

    /**
     * 审核
     * @param schoolXacademicWorks
     * @return
     */
    int audit(SchoolXacademicWorks schoolXacademicWorks);

}
