package yangtz.cs.liu.campus.service.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.AjaxResult;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAclassTeacherAssessment;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAclassTeacherAssessmentReq;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAclassTeacherAssessmentVo;

import java.util.List;

/**
 * 班主任考核Service接口
 *
 * @author ruoyi
 * @date 2023-12-12
 */
public interface ISchoolAclassTeacherAssessmentService  extends IService<SchoolAclassTeacherAssessment>
{
    /**
     * 查询班主任考核
     *
     * @param id 班主任考核主键
     * @return 班主任考核
     */
    public SchoolAclassTeacherAssessment selectSchoolAclassTeacherAssessmentById(Long id);

    AjaxResult  saveCheckedDate(List<SchoolAclassTeacherAssessment> detailList);
    /**
     * 查询班主任考核列表
     *
     * @param req 班主任考核
     * @return 班主任考核集合
     */
    public List<SchoolAclassTeacherAssessmentVo> selectSchoolAclassTeacherAssessmentList(SchoolAclassTeacherAssessmentReq req);
    public List<SchoolAclassTeacherAssessment> selectSchoolList(SchoolAclassTeacherAssessmentReq req);

    /**
     * 新增班主任考核
     *
     * @param schoolAclassTeacherAssessment 班主任考核
     * @return 结果
     */
    public int insertSchoolAclassTeacherAssessment(SchoolAclassTeacherAssessment schoolAclassTeacherAssessment);

    /**
     * 修改班主任考核
     *
     * @param schoolAclassTeacherAssessment 班主任考核
     * @return 结果
     */
    public int updateSchoolAclassTeacherAssessment(SchoolAclassTeacherAssessment schoolAclassTeacherAssessment);

    /**
     * 批量删除班主任考核
     *
     * @param ids 需要删除的班主任考核主键集合
     * @return 结果
     */
    public int deleteSchoolAclassTeacherAssessmentByIds(Long[] ids);

    /**
     * 删除班主任考核信息
     *
     * @param id 班主任考核主键
     * @return 结果
     */
    public int deleteSchoolAclassTeacherAssessmentById(Long id);
}
