package yangtz.cs.liu.campus.service.schoolLab;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.entity.SysUser;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabCompetition;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabCompetitionVo;

import java.util.List;
import java.util.Map;

/**
 * 实验室竞赛Service接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface ISchoolLabCompetitionService extends IService<SchoolLabCompetition>
{
    /**
     * 查询实验室竞赛
     *
     * @param id 实验室竞赛主键
     * @return 实验室竞赛
     */
    public SchoolLabCompetitionVo selectSchoolLabCompetitionById(Long id);

    /**
     * 查询实验室竞赛列表
     *
     * @param schoolLabCompetitionVo 实验室竞赛
     * @return 实验室竞赛集合
     */
    public List<SchoolLabCompetitionVo> selectSchoolLabCompetitionList(SchoolLabCompetitionVo schoolLabCompetitionVo);

    /**
     * 新增实验室竞赛
     *
     * @param schoolLabCompetitionVo 实验室竞赛
     * @return 结果
     */
    public int insertSchoolLabCompetition(SchoolLabCompetitionVo schoolLabCompetitionVo);

    /**
     * 修改实验室竞赛
     *
     * @param schoolLabCompetitionVo 实验室竞赛
     * @return 结果
     */
    public int updateSchoolLabCompetition(SchoolLabCompetitionVo schoolLabCompetitionVo);

    /**
     * 批量删除实验室竞赛
     *
     * @param ids 需要删除的实验室竞赛主键集合
     * @return 结果
     */
    public int deleteSchoolLabCompetitionByIds(Long[] ids);

    /**
     * 删除实验室竞赛信息
     *
     * @param id 实验室竞赛主键
     * @return 结果
     */
    public int deleteSchoolLabCompetitionById(Long id);

    /**
     * 获取教师
     * @param sysUser
     * @return
     */
    List<Map<String,Object>> getTeacher(SysUser sysUser);
}
