package yangtz.cs.liu.campus.service.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.IService;
import java.util.List;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentRepair;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolEquipmentRepairVo;

import java.util.List;
import java.util.Map;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveQuery;

public interface IEquipmentRepairService extends IService<SchoolEquipmentRepair> {
    /**
     * 查看设备报修列表
     * @param schoolEquipmentRepairVo
     * @return
     */
    List<SchoolEquipmentRepairVo> selectSchoolEquipmentRepairVoList(SchoolEquipmentRepairVo schoolEquipmentRepairVo);

    /**
     * 查看设备报修详细信息
     * @param id
     * @return
     */
    SchoolEquipmentRepairVo selectSchoolEquipmentRepairVoById(Long id);
    List<SchoolEquipmentRepairVo> getAdminList(SchoolReceiveQuery schoolReceiveQuery);


    /**
     * 新增设备报修
     * @return
     */
    int insertSchoolEquipmentRepairVo(SchoolEquipmentRepair schoolEquipmentRepair);

    /**
     * 修改设备报修
     * @param schoolEquipmentRepair
     * @return
     */
    int updateSchoolEquipmentRepair(SchoolEquipmentRepair schoolEquipmentRepair);

    /**
     * 删除设备报修
     * @param ids
     * @return
     */
    int deleteSchoolEquipmentRepairById(Long[] ids);

    /**
     * 根据自编码获取设备信息
     * @param encode
     * @return
     */
    Map<String,String> getEquipment(String encode);

    /**
     * 获取修理人下拉框
     * @return
     */
    List<Map<String,String>> getRepair();

    public SchoolEquipmentRepairVo getEquipmentById(Long id);

  public List<SchoolEquipmentRepairVo> getMaintenanceList(SchoolReceiveQuery schoolReceiveQuery);

  public List<SchoolEquipmentRepairVo> getlist();


  public List<SchoolEquipmentRepairVo> getMaintenanceUserList(SchoolReceiveQuery schoolReceiveQuery);


}
