package yangtz.cs.liu.campus.service.schoolDcwj;

import com.baomidou.mybatisplus.extension.service.IService;
import org.springframework.web.bind.annotation.RequestBody;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwj;
import yangtz.cs.liu.campus.vo.schoolDcwj.DawjVo;
import yangtz.cs.liu.campus.vo.schoolDcwj.DcwjSenateVo;
import yangtz.cs.liu.wechat.vo.schoolDcwj.SchoolDcwjVo;
import yangtz.cs.liu.wechat.vo.schoolDcwj.Vo_SchoolDcwj;

import java.util.List;

/**
 * 调查问卷Service接口
 *
 * @author wengxiulin
 * @date 2023-02-27
 */
public interface ISchoolDcwjService extends IService<SchoolDcwj> {
    /**
     * 查询调查问卷列表
     *
     * @param schoolDcwj 调查问卷
     * @return 调查问卷集合
     */
    public List<SchoolDcwj> selectSchoolDcwjList(SchoolDcwj schoolDcwj);
    //按级部过滤
    public List<DawjVo> queryList(List<Long> idList,SchoolDcwj schoolDcwj);

    /**
     * 修改调查问卷
     *
     * @param schoolDcwj 调查问卷
     * @return 结果
     */
    public int updateSchoolDcwj(SchoolDcwj schoolDcwj);

    /**
     * 批量删除调查问卷
     *
     * @param ids 需要删除的调查问卷主键集合
     * @return 结果
     */
    public int deleteSchoolDcwjByIds(Long[] ids);

    /**
     * 删除调查问卷信息
     *
     * @param id 调查问卷主键
     * @return 结果
     */
    public int deleteSchoolDcwjById(Long id);


    /*
    wx获取调查问卷列表  ==>家长
     */
    List<Vo_SchoolDcwj> getDcwjList(Long studentId,String state);

    /*
    wx获取调查问卷列表  ==>教职工
     */
    List<Vo_SchoolDcwj> teacherGetDcwjList(Long teacherId, String state);

    /**
     * 教务管理-问卷调查-列表查看
     * */
    public List<DcwjSenateVo> senateList(SchoolDcwj schoolDcwj);

    /**
     * 教务管理-问卷调查-新增
     **/
    int senateAdd(DcwjSenateVo senateVo);

    /**
     * 教务管理-问卷调查-详细信息
     */
    DcwjSenateVo senateQueryInfo(Long id);

    /**
     * 教务管理-问卷调查-修改
     **/
    int senateEdit(DcwjSenateVo senateVo);

    /**
     * 教务管理-问卷调查-发布
     **/
    int senatePub(Long id);

    /**
     * 教务管理-问卷调查-撤回
     **/
    int senateWithdraw(Long id);
}
