package yangtz.cs.liu.campus.service.schoolDcwj;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjNr;
import yangtz.cs.liu.campus.vo.schoolDcwj.DcwjNrVo;
import yangtz.cs.liu.campus.vo.schoolDcwj.SchoolDcwjAnVo;
import yangtz.cs.liu.campus.vo.schoolDcwj.ViewDataVo;
import yangtz.cs.liu.campus.vo.schoolDcwj.ViewTitlesVo;
import yangtz.cs.liu.wechat.vo.schoolDcwj.Vo_SchoolDcwjNr;

import java.util.List;

/**
 * 内容问题Service接口
 *
 * @author wengxiulin
 * @date 2023-02-27
 */
public interface ISchoolDcwjNrService extends IService<SchoolDcwjNr>
{
    /**
     * 查询内容问题
     *
     * @param id 内容问题主键
     * @return 内容问题
     */
    public SchoolDcwjNr selectSchoolDcwjNrById(Long id);

    /**
     * 查询内容问题列表
     *
     * @param schoolDcwjNr 内容问题
     * @return 内容问题集合
     */
    public List<SchoolDcwjNr> selectSchoolDcwjNrList(SchoolDcwjNr schoolDcwjNr);

    /**
     * 新增内容问题
     *
     * @param schoolDcwjNr 内容问题
     * @return 结果
     */
    public int insertSchoolDcwjNr(SchoolDcwjNr schoolDcwjNr);

    /**
     * 修改内容问题
     *
     * @param schoolDcwjNr 内容问题
     * @return 结果
     */
    public int updateSchoolDcwjNr(SchoolDcwjNr schoolDcwjNr);

    /**
     * 批量删除内容问题
     *
     * @param ids 需要删除的内容问题主键集合
     * @return 结果
     */
    public int deleteSchoolDcwjNrByIds(Long[] ids);

    /**
     * 删除内容问题信息
     *
     * @param id 内容问题主键
     * @return 结果
     */
    public int deleteSchoolDcwjNrById(Long id);

    String importDcwjNrListData(List<SchoolDcwjNr> dcwjNrList, Long dcwjId);

    /**
     * wx获取某一个调查问卷下题目+用户回答详情
     */
    List<Vo_SchoolDcwjNr> getDcwjNrList(Long dcwjId,Long studentId,Long teacherId);

    List<SchoolDcwjNr> getNrBtByDcwjId(Long dcwjId);

    ViewTitlesVo turnTitles(List<SchoolDcwjNr> list);

    List<ViewDataVo> turnData(List<SchoolDcwjAnVo> list);

    /**
     * 新增或修改时，获取排序在本题之上的选择或多选题,即排讯号小于当前题目的排序
     * */
    List<SchoolDcwjNr> getSelectList(SchoolDcwjNr schoolDcwjNr);

    /**
     * 删除所有页面逻辑
     * */
    int deleteAllLogic(Long dcwjId);

    /**
     * 是否被其他题所关联
     */
    public boolean hasRelationById(Long id);

    //获取题目选择项
    public DcwjNrVo queryById(Long id);
}
