package yangtz.cs.liu.campus.service.recruit;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.model.WebLoginBody;
import java.util.List;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitStudent;
import yangtz.cs.liu.campus.vo.recruit.RecruitAndEduStudentVo;
import yangtz.cs.liu.campus.vo.recruit.RecruitEduStudentVo;
import yangtz.cs.liu.campus.vo.recruit.SchoolRecruitStudentExportVo;
import yangtz.cs.liu.webpage.domain.WebRegisterBody;
import yangtz.cs.liu.webpage.vo.QueryScoreVo;
import yangtz.cs.liu.webpage.vo.RecruitAdmissionTicketVo;
import yangtz.cs.liu.webpage.vo.WebSchoolRecruitStudentVo;

/**
 * @author xuten
 */
public interface ISchoolRecruitStudentService extends IService<SchoolRecruitStudent> {

    /**
     * 艺考生网页注册
     * */
    public String register(WebRegisterBody registerBody);

    /**
     * 艺考生网页登录
     * */
    public WebLoginBody login(WebRegisterBody webRegisterBody);

    /**
     * 判断能不能点进去进入按钮
     * 1能 0不能
     * 当前状态（0=报名，1=待审核，2=通过，3=驳回，4=信息修改，5=准考证打印，6=成绩查询，7=审核）
     * */
    public int enterBtn(Long studentId, Long testId);

    /**获取考生信息详情*/
    WebSchoolRecruitStudentVo getInfo(Long id);

    /**
     * 获取考试考生详情
     * */
    WebSchoolRecruitStudentVo getStuInfo(Long id, Long examId);

    //根据考试id和考生id获取准考证信息(前提是当前学生已通过审核，且考试状态位于成绩发布)
    RecruitAdmissionTicketVo getTicket(Long studentId, Long examId);

    //根据考试id和考生id获取考试成绩信息(前提是当前学生已通过审核，且考试状态位于成绩发布)
    QueryScoreVo getScore(Long studentId, Long examId);

    //考生报名界面-暂存
    public int webSave(Long examId, WebSchoolRecruitStudentVo student);

    //考生报名界面-提交
    public int webSubmit(Long examId, WebSchoolRecruitStudentVo student);

    /** 教务管理-考试管理-信息审核列表 */
    List<RecruitEduStudentVo> getInfoCheck(RecruitEduStudentVo vo);

    /** 教务管理-考试管理-信息审核-修改 */
    int editRecruitAndEdu(Long examId, RecruitAndEduStudentVo student);
    int edit(Long examId, WebSchoolRecruitStudentVo student);

    /** 教务管理-考试管理-信息审核-导出报名信息  */
    List<SchoolRecruitStudentExportVo> editExport(List<Long> idList, Long examId);

    /** 教务管理-考试管理-通过 */
    String pass(Long examId, List<Long> studentIds);

    /** 教务管理-考试管理-单个通过 */
    int passOne(Long examId, Long studentId);

    /** 教务管理-考试管理-退回修改 */
    String back(Long examId, List<Long> studentIds);

    /** 教务管理-考试管理-单个退回修改 */
    int backOne(Long examId, Long studentId, String backMessage);

    /** 教务管理-考试管理-驳回 */
    String reject(Long examId, List<Long> studentIds);

    /** 教务管理-考试管理-单个驳回 */
    int rejectOne(Long examId, Long studentId);

    /**
     * 考务管理-考生账号管理-列表
     * */
    List<SchoolRecruitStudent> queryList(SchoolRecruitStudent student);
}
