package yangtz.cs.liu.campus.service.recruit;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitRelation;
import yangtz.cs.liu.campus.vo.recruit.RecruitExamAddressVo;
import yangtz.cs.liu.campus.vo.recruit.RecruitExamScoreVo;

import java.util.List;

public interface ISchoolRecruitRelationService extends IService<SchoolRecruitRelation> {

    //通过考试id和考生id获取关系
    SchoolRecruitRelation getRelationByIds(Long examId, Long studentId);

    /**
     * 考试管理-考场分配-列表
     * */
    List<RecruitExamAddressVo> getAddressList(RecruitExamAddressVo vo);

    RecruitExamScoreVo getAddressInfo(Long id);

    /**
     * 考试管理-考试管理-列表
     * */
    List<RecruitExamScoreVo> getScoreList(RecruitExamScoreVo vo);

    /**
     * 校验导入的考场数据
     * */
    void checkImportAddress(List<RecruitExamAddressVo> list);

    /**
     * 导入考场数据
     * */
    String importDataAddress(List<RecruitExamAddressVo> list, Long examId);

    /**
     * 考试管理-考场分配-结束
     */
    int addressEnd(Long examId);

    /**
     * 校验导入的成绩数据
     * */
    void checkImportScore(List<RecruitExamScoreVo> list);

    /**
     * 导入成绩数据
     * */
    String importDataScore(List<RecruitExamScoreVo> list, Long examId);

    /**
     * 考试管理-成绩发布-结束
     */
    int scoreEnd(Long examId);

}
