package yangtz.cs.liu.campus.service.impl.vehicle;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicle;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicleApplication;
import yangtz.cs.liu.campus.mapper.vehicle.SchoolVehicleMapper;
import yangtz.cs.liu.campus.service.vehicle.ISchoolVehicleService;
import yangtz.cs.liu.campus.vo.vehicle.SchoolVehicleVO;
import yangtz.cs.liu.campus.vo.vehicle.VehicleLicenseVO;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 车辆信息Service业务层处理
 *
 * @author xu
 * @date 2022-09-29
 */
@Service
public class SchoolVehicleServiceImpl extends ServiceImpl<SchoolVehicleMapper, SchoolVehicle> implements ISchoolVehicleService
{
    @Autowired
    private SchoolVehicleMapper schoolVehicleMapper;

    /**
     * 查询车辆信息列表
     *
     * @param schoolVehicle 车辆信息
     * @return 车辆信息
     */
    @Override
    public List<SchoolVehicle> queryList(SchoolVehicleVO schoolVehicle)
    {
        LambdaQueryWrapper<SchoolVehicle> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolVehicle.getVehicleBrand()), SchoolVehicle::getVehicleBrand,schoolVehicle.getVehicleBrand())
                .like(isNotBlank(schoolVehicle.getLicensePlate()), SchoolVehicle::getLicensePlate,schoolVehicle.getLicensePlate())
                .eq(isNotNull(schoolVehicle.getVehicleType()), SchoolVehicle::getVehicleType,schoolVehicle.getVehicleType())
                .eq(isNotNull(schoolVehicle.getVehicleFuel()), SchoolVehicle::getVehicleFuel,schoolVehicle.getVehicleFuel())
                .ge(isNotNull(schoolVehicle.getProductionStart()),SchoolVehicle::getDateOfProduction,schoolVehicle.getProductionStart())
                .le(isNotNull(schoolVehicle.getProductionEnd()),SchoolVehicle::getDateOfProduction,schoolVehicle.getProductionEnd())
                .eq(isNotNull(schoolVehicle.getVehicleState()), SchoolVehicle::getVehicleState,schoolVehicle.getVehicleState())
                .orderByDesc(SchoolVehicle::getCreateTime)
        ;
//        if (StringUtils.isNotNull(schoolVehicle.getDateOfProduction())) {
//            lqw.like(StringUtils.isNotNull(schoolVehicle.getDateOfProduction()), SchoolVehicle::getDateOfProduction, DateUtils.parseDateToStr("yyyy-MM-dd", schoolVehicle.getDateOfProduction()));
//        }
        return schoolVehicleMapper.selectList(lqw);
    }

    @Override
    public List<VehicleLicenseVO> getList(SchoolVehicleVO schoolVehicle) {
        return schoolVehicleMapper.getList(schoolVehicle);
    }

}
