package yangtz.cs.liu.campus.service.impl.vehicle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.PageDomain;
import com.ruoyi.common.core.page.TableSupport;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysUserService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.persistence.entity.TaskEntityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import yangtz.cs.liu.activiti.service.IProcessService;
import yangtz.cs.liu.campus.domain.office.SchoolOfficePurchase;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherWages;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicle;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicleApplication;
import yangtz.cs.liu.campus.mapper.vehicle.SchoolVehicleApplicationMapper;
import yangtz.cs.liu.campus.service.vehicle.ISchoolVehicleApplicationService;
import yangtz.cs.liu.campus.vo.office.OfficeTodoListVO;
import yangtz.cs.liu.campus.vo.vehicle.VehicleApplicationVO;

import javax.annotation.Resource;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;
import static com.core.constant.ProcessCommon.*;
import static com.core.constant.ProcessVariables.CHARGEUSERID;
import static com.core.constant.ProcessVariables.CHARGEUSERIDS;

/**
 * 用车申请Service业务层处理
 *
 * @author xu
 * @date 2022-09-29
 */
@Service
public class SchoolVehicleApplicationServiceImpl extends ServiceImpl<SchoolVehicleApplicationMapper, SchoolVehicleApplication> implements ISchoolVehicleApplicationService {
    @Autowired
    private SchoolVehicleApplicationMapper schoolVehicleApplicationMapper;
    @Resource
    private IdentityService identityService;

    @Override
    public List<VehicleApplicationVO> queryList(VehicleApplicationVO vehicleApplicationVO) {

        return schoolVehicleApplicationMapper.queryList(vehicleApplicationVO);

    }

    @Override
    public List<VehicleApplicationVO> getByIds(List<Long> ids) {
        return schoolVehicleApplicationMapper.getByIds(ids);
    }

    //获取车辆申请详情
    @Override
    public VehicleApplicationVO getInfo(Long id) {
        return schoolVehicleApplicationMapper.getInfo(id);
    }

    @Override
    public int submitApply(SchoolVehicleApplication schoolVehicleApplication, String username, String key) {
        return 0;
    }

}


