package yangtz.cs.liu.campus.service.impl.training;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.mapper.accessory.AccessoryMapper;
import yangtz.cs.liu.campus.mapper.training.TrainingMapper;
import yangtz.cs.liu.campus.domain.training.Training;
import yangtz.cs.liu.campus.service.training.ITrainingService;

/**
 * 培训情况Service业务层处理
 *
 * @author ruoyi
 * @date 2023-07-25
 */
@Service
public class TrainingServiceImpl implements ITrainingService
{
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private AccessoryMapper accessoryMapper;

    /**
     * 查询培训情况
     *
     * @param id 培训情况主键
     * @return 培训情况
     */
    @Override
    public Training selectTrainingById(Long id)
    {
        Training training = trainingMapper.selectTrainingById(id);
        LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAccessory::getBusinessId,training.getId())
                .eq(SchoolAccessory::getAccessoryType,"培训情况附件");
        List<SchoolAccessory> accessories = accessoryMapper.selectList(wrapper);
        if (StringUtils.isNotNull(accessories) && accessories.size() > 0){
            training.setSchoolAccessoryList(accessories);
        }
        return training;
    }

    /**
     * 查询培训情况列表
     *
     * @param training 培训情况
     * @return 培训情况
     */
    @Override
    public List<Training> selectTrainingList(Training training)
    {
        training.setTeacherId(SecurityUtils.getLoginUser().getUser().getUserId());
        List<Training> list = trainingMapper.selectTrainingList(training);
        list.forEach(training1 -> {
            LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolAccessory::getBusinessId,training1.getId())
                    .eq(SchoolAccessory::getAccessoryType,"培训情况附件");
            List<SchoolAccessory> accessories = accessoryMapper.selectList(wrapper);
            if (StringUtils.isNotNull(accessories) && accessories.size() > 0){
                training1.setSchoolAccessoryList(accessories);
            }
        });
        return list;
    }

    /**
     * 新增培训情况
     *
     * @param training 培训情况
     * @return 结果
     */
    @Transactional
    @Override
    public int insertTraining(Training training)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        training.setTeacherId(user.getUserId());
        training.setTeacherName(user.getUserName());
        training.setCreateBy(user.getUserName());
        training.setCreateTime(DateUtils.getNowDate());
        int rows = trainingMapper.insertTraining(training);
        insertSchoolAccessory(training);
        return rows;
    }

    /**
     * 修改培训情况
     *
     * @param training 培训情况
     * @return 结果
     */
    @Transactional
    @Override
    public int updateTraining(Training training)
    {
        training.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        training.setUpdateTime(DateUtils.getNowDate());
        trainingMapper.deleteSchoolAccessoryByBusinessId(training.getId());
        insertSchoolAccessory(training);
        return trainingMapper.updateTraining(training);
    }

    /**
     * 批量删除培训情况
     *
     * @param ids 需要删除的培训情况主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteTrainingByIds(Long[] ids)
    {
        trainingMapper.deleteSchoolAccessoryByBusinessIds(ids);
        return trainingMapper.deleteTrainingByIds(ids);
    }

    /**
     * 删除培训情况信息
     *
     * @param id 培训情况主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteTrainingById(Long id)
    {
        trainingMapper.deleteSchoolAccessoryByBusinessId(id);
        return trainingMapper.deleteTrainingById(id);
    }

    /**
     * 新增附件信息信息
     *
     * @param training 培训情况对象
     */
    public void insertSchoolAccessory(Training training)
    {
        List<SchoolAccessory> schoolAccessoryList = training.getSchoolAccessoryList();
        Long id = training.getId();
        if (StringUtils.isNotNull(schoolAccessoryList))
        {
            List<SchoolAccessory> list = new ArrayList<SchoolAccessory>();
            for (SchoolAccessory schoolAccessory : schoolAccessoryList)
            {
                schoolAccessory.setModuleName("个人工作-培训情况");
                schoolAccessory.setAccessoryType("培训情况附件");
                schoolAccessory.setBusinessId(id);
                list.add(schoolAccessory);
            }
            if (list.size() > 0)
            {
                trainingMapper.batchSchoolAccessory(list);
            }
        }
    }
}
