package yangtz.cs.liu.campus.service.impl.teacher;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherDuty;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherDutyMapper;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherDutyService;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherDutyVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherDutyMap;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

@Service
public class SchoolTeacherDutyServiceImpl extends ServiceImpl<SchoolTeacherDutyMapper, SchoolTeacherDuty> implements ISchoolTeacherDutyService {

    @Autowired
    private SchoolTeacherDutyMapper schoolTeacherDutyMapper;

    @Override
    public List<SchoolTeacherDuty> queryList(SchoolTeacherDuty schoolTeacherDuty) {
        LambdaQueryWrapper<SchoolTeacherDuty> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(schoolTeacherDuty.getTeacherId()), SchoolTeacherDuty::getTeacherId, schoolTeacherDuty.getTeacherId())
                .like(isNotBlank(schoolTeacherDuty.getTeacherName()), SchoolTeacherDuty::getTeacherName, schoolTeacherDuty.getTeacherName())
                .eq(isNotNull(schoolTeacherDuty.getDutyType()), SchoolTeacherDuty::getDutyType, schoolTeacherDuty.getDutyType())
                .apply(ObjectUtil.isNotNull(schoolTeacherDuty.getParams().get("beginTime")),
                        "date_format(duty_time,'%Y-%m-%d') >= date_format('" + schoolTeacherDuty.getParams().get("beginTime") + "','%Y-%m-%d') ")
                .apply(ObjectUtil.isNotNull(schoolTeacherDuty.getParams().get("endTime")),
                        "date_format(duty_time,'%Y-%m-%d') <= date_format('" + schoolTeacherDuty.getParams().get("endTime") + "','%Y-%m-%d') ")
                .orderByDesc(SchoolTeacherDuty::getDutyTime)
        ;
        return schoolTeacherDutyMapper.selectList(lqw);

    }

    //首页值班表，OK
    @Override
   /* public List<TeacherDutyMap> getList(SchoolTeacherDutyVO schoolTeacherDutyVO) {
        List<SchoolTeacherDutyVO> list = schoolTeacherDutyMapper.getList(schoolTeacherDutyVO);
        if (null == list) {
            return new ArrayList<>();
        }
        List<SchoolTeacherDutyVO> listVO = setWeek(list);

        //创建值班表map
        Map<Date, List<SchoolTeacherDutyVO>> map = new HashMap<>();
        for (SchoolTeacherDutyVO dutyVO : listVO) {
            //根据值班日期拿到集合,
            List<SchoolTeacherDutyVO> vo = map.getOrDefault(dutyVO.getDutyTime(), new ArrayList<>());
            SchoolTeacherDutyVO obj = new SchoolTeacherDutyVO();
            BeanUtils.copyProperties(dutyVO, obj);
            vo.add(obj);
            map.put(dutyVO.getDutyTime(), vo);
        }
        List<TeacherDutyMap> dutyMapList = new ArrayList<>();
        for (Map.Entry<Date, List<SchoolTeacherDutyVO>> entry : map.entrySet()) {
            //遍历
            List<SchoolTeacherDutyVO> voList = entry.getValue();
            TeacherDutyMap dutyMap = new TeacherDutyMap();
            dutyMap.setDutyTime(voList.get(0).getDutyTime());
            dutyMap.setWeekDay(voList.get(0).getWeekDay());
            dutyMap.setList(voList);
            dutyMapList.add(dutyMap);
        }
        //按日期升序
        Collections.sort(dutyMapList , new Comparator<TeacherDutyMap>() {
            @Override
            public int compare(TeacherDutyMap o1, TeacherDutyMap o2) {
                return o1.getDutyTime().compareTo(o2.getDutyTime());
            }
        });
        // 取反  降序
        Collections.reverse(dutyMapList);
        return dutyMapList;
    }*/
    public List<SchoolTeacherDutyVO> getList(SchoolTeacherDutyVO schoolTeacherDutyVO) {
        List<SchoolTeacherDutyVO> list = schoolTeacherDutyMapper.getList(schoolTeacherDutyVO);
        if (null == list) {
            return new ArrayList<>();
        }
        List<SchoolTeacherDutyVO> listVO = setWeek(list);
        return list;
    }

    //设置值班表星期几
    public List<SchoolTeacherDutyVO> setWeek(List<SchoolTeacherDutyVO> list) {

        for (SchoolTeacherDutyVO dutyVO : list) {
            String[] weekDays = {"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};
            Calendar cal = Calendar.getInstance();
            cal.setTime(dutyVO.getDutyTime());
            //因为数组下标从0开始，而返回的是数组的内容，是数组{1,2,3,4,5,6,7}中用1~7来表示，所以要减1
            int week = cal.get(Calendar.DAY_OF_WEEK) - 1;
            if (week < 0) {
                week = 0;
            }
            dutyVO.setWeekDay(weekDays[week]);
        }
        return list;
    }

}
