package yangtz.cs.liu.campus.service.impl.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.domain.student.SchoolStudentSection;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentSectionMapper;
import yangtz.cs.liu.campus.service.student.ISchoolStudentSectionService;
import yangtz.cs.liu.campus.vo.student.SchoolStudentSectionVo;

import java.util.ArrayList;
import java.util.List;

@Service
public class SchoolStudentSectionServiceImpl extends ServiceImpl<SchoolStudentSectionMapper,SchoolStudentSection>implements ISchoolStudentSectionService {

    @Autowired
    private SchoolStudentSectionMapper schoolStudentSectionMapper;

    @Autowired
    private SchoolStudentMapper schoolStudentMapper;

//    @Override
//    public int selectChooseNum(Long gradeId) {
//        List<SchoolStudentSectionVo> schoolStudentSections = schoolStudentSectionMapper.select(gradeId);
//        int size = schoolStudentSections.size();
//        return size;
//    }

    @Override
    public List<SchoolStudentSectionVo> select(SchoolStudentSectionVo schoolStudentSectionVo) {
        return schoolStudentSectionMapper.select(schoolStudentSectionVo);
    }

    @Override
    public List<SchoolStudent> noSelect(SchoolStudent schoolStudent) {
        //获取已经选择过学生的id
        LambdaQueryWrapper<SchoolStudentSection> lqw = new LambdaQueryWrapper<>();
        List<SchoolStudentSection> sectionList = schoolStudentSectionMapper.selectList(lqw);
        List<Long> studentIds = new ArrayList<>();
        for (SchoolStudentSection sectionId : sectionList) {
            studentIds.add(sectionId.getStudentId());
        }
        //查询班级中不包含已选择过的学生
        List<SchoolStudent> student = schoolStudentMapper.noSelect(studentIds, schoolStudent);
        return student;
    }
}
